/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.SchemaEntity;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Column", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableColumn
extends Column {
    private final String name;
    @Nullable
    private final Column.ColumnType type;
    @Nullable
    private final Column.Kind kind;
    @Nullable
    private final String keyspace;
    @Nullable
    private final String table;
    @Nullable
    private final Column.Order order;
    private final int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long CQL_NAME_LAZY_INIT_BIT = 1L;
    private transient String cqlName;
    private static final long serialVersionUID = 2199514488330101566L;

    private ImmutableColumn(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.kind = builder.kind;
        this.keyspace = builder.keyspace;
        this.table = builder.table;
        this.order = builder.orderIsSet() ? builder.order : super.order();
        this.hashCode = this.computeHashCode();
    }

    private ImmutableColumn(String name, @Nullable Column.ColumnType type, @Nullable Column.Kind kind, @Nullable String keyspace, @Nullable String table, @Nullable Column.Order order) {
        this.name = name;
        this.type = type;
        this.kind = kind;
        this.keyspace = keyspace;
        this.table = table;
        this.order = order;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public Column.ColumnType type() {
        return this.type;
    }

    @Override
    @Nullable
    public Column.Kind kind() {
        return this.kind;
    }

    @Override
    @Nullable
    public String keyspace() {
        return this.keyspace;
    }

    @Override
    @Nullable
    public String table() {
        return this.table;
    }

    @Override
    @Nullable
    public Column.Order order() {
        return this.order;
    }

    public final ImmutableColumn withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableColumn(newValue, this.type, this.kind, this.keyspace, this.table, this.order);
    }

    public final ImmutableColumn withType(@Nullable Column.ColumnType value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableColumn(this.name, value, this.kind, this.keyspace, this.table, this.order);
    }

    public final ImmutableColumn withKind(@Nullable Column.Kind value) {
        if (this.kind == value) {
            return this;
        }
        if (Objects.equals((Object)this.kind, (Object)value)) {
            return this;
        }
        return new ImmutableColumn(this.name, this.type, value, this.keyspace, this.table, this.order);
    }

    public final ImmutableColumn withKeyspace(@Nullable String value) {
        if (Objects.equals(this.keyspace, value)) {
            return this;
        }
        return new ImmutableColumn(this.name, this.type, this.kind, value, this.table, this.order);
    }

    public final ImmutableColumn withTable(@Nullable String value) {
        if (Objects.equals(this.table, value)) {
            return this;
        }
        return new ImmutableColumn(this.name, this.type, this.kind, this.keyspace, value, this.order);
    }

    public final ImmutableColumn withOrder(@Nullable Column.Order value) {
        if (this.order == value) {
            return this;
        }
        if (Objects.equals((Object)this.order, (Object)value)) {
            return this;
        }
        return new ImmutableColumn(this.name, this.type, this.kind, this.keyspace, this.table, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableColumn && this.equalTo((ImmutableColumn)another);
    }

    private boolean equalTo(ImmutableColumn another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.name.equals(another.name) && Objects.equals(this.type, another.type) && Objects.equals((Object)this.kind, (Object)another.kind) && Objects.equals(this.keyspace, another.keyspace) && Objects.equals(this.table, another.table) && Objects.equals((Object)this.order, (Object)another.order);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode((Object)this.kind);
        h += (h << 5) + Objects.hashCode(this.keyspace);
        h += (h << 5) + Objects.hashCode(this.table);
        h += (h << 5) + Objects.hashCode((Object)this.order);
        return h;
    }

    public String toString() {
        return "Column{name=" + this.name + ", type=" + this.type + ", kind=" + (Object)((Object)this.kind) + ", keyspace=" + this.keyspace + ", table=" + this.table + ", order=" + (Object)((Object)this.order) + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String cqlName() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableColumn immutableColumn = this;
            synchronized (immutableColumn) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.cqlName = Objects.requireNonNull(super.cqlName(), "cqlName");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.cqlName;
    }

    public static ImmutableColumn copyOf(Column instance) {
        if (instance instanceof ImmutableColumn) {
            return (ImmutableColumn)instance;
        }
        return ImmutableColumn.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return new ImmutableColumn(this.name, this.type, this.kind, this.keyspace, this.table, this.order);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Column", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements Column.Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long OPT_BIT_ORDER = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String name;
        @Nullable
        private Column.ColumnType type;
        @Nullable
        private Column.Kind kind;
        @Nullable
        private String keyspace;
        @Nullable
        private String table;
        @Nullable
        private Column.Order order;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SchemaEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Column instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SchemaEntity instance;
            if (object instanceof SchemaEntity) {
                instance = (SchemaEntity)object;
                this.name(instance.name());
            }
            if (object instanceof Column) {
                Column.Order orderValue;
                String tableValue;
                Column.Kind kindValue;
                Column.ColumnType typeValue;
                instance = (Column)object;
                String keyspaceValue = ((Column)instance).keyspace();
                if (keyspaceValue != null) {
                    this.keyspace(keyspaceValue);
                }
                if ((typeValue = ((Column)instance).type()) != null) {
                    this.type(typeValue);
                }
                if ((kindValue = ((Column)instance).kind()) != null) {
                    this.kind(kindValue);
                }
                if ((tableValue = ((Column)instance).table()) != null) {
                    this.table(tableValue);
                }
                if ((orderValue = ((Column)instance).order()) != null) {
                    this.order(orderValue);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder type(@Nullable Column.ColumnType type) {
            this.type = type;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder kind(@Nullable Column.Kind kind) {
            this.kind = kind;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyspace(@Nullable String keyspace) {
            this.keyspace = keyspace;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder table(@Nullable String table) {
            this.table = table;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder order(@Nullable Column.Order order) {
            this.order = order;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableColumn build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableColumn(this);
        }

        private boolean orderIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Column, some of required attributes are not set " + attributes;
        }
    }
}

