/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ParameterizedType;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ParameterizedType.ListType", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableListType
extends ParameterizedType.ListType {
    private final boolean isFrozen;
    private final List<Column.ColumnType> parameters;
    private final int hashCode;

    private ImmutableListType(Builder builder) {
        this.parameters = ImmutableListType.createUnmodifiableList(true, builder.parameters);
        this.isFrozen = builder.isFrozenIsSet() ? builder.isFrozen : super.isFrozen();
        this.hashCode = this.computeHashCode();
    }

    private ImmutableListType(boolean isFrozen, List<Column.ColumnType> parameters) {
        this.isFrozen = isFrozen;
        this.parameters = parameters;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public boolean isFrozen() {
        return this.isFrozen;
    }

    @Override
    public List<Column.ColumnType> parameters() {
        return this.parameters;
    }

    @Override
    public final ImmutableListType withIsFrozen(boolean value) {
        if (this.isFrozen == value) {
            return this;
        }
        return new ImmutableListType(value, this.parameters);
    }

    public final ImmutableListType withParameters(Column.ColumnType ... elements) {
        List<Column.ColumnType> newValue = ImmutableListType.createUnmodifiableList(false, ImmutableListType.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableListType(this.isFrozen, newValue);
    }

    public final ImmutableListType withParameters(Iterable<? extends Column.ColumnType> elements) {
        if (this.parameters == elements) {
            return this;
        }
        List<Column.ColumnType> newValue = ImmutableListType.createUnmodifiableList(false, ImmutableListType.createSafeList(elements, true, false));
        return new ImmutableListType(this.isFrozen, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableListType && this.equalTo((ImmutableListType)another);
    }

    private boolean equalTo(ImmutableListType another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.isFrozen == another.isFrozen && this.parameters.equals(another.parameters);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.isFrozen);
        h += (h << 5) + this.parameters.hashCode();
        return h;
    }

    public String toString() {
        return "ListType{isFrozen=" + this.isFrozen + ", parameters=" + this.parameters + "}";
    }

    public static ImmutableListType copyOf(ParameterizedType.ListType instance) {
        if (instance instanceof ImmutableListType) {
            return (ImmutableListType)instance;
        }
        return ImmutableListType.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return new ImmutableListType(this.isFrozen, this.parameters);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ParameterizedType.ListType", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends ParameterizedType.ListType.Builder {
        private static final long OPT_BIT_IS_FROZEN = 1L;
        private long optBits;
        private boolean isFrozen;
        private List<Column.ColumnType> parameters = new ArrayList<Column.ColumnType>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Column.ColumnType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ParameterizedType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ParameterizedType.ListType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Column.ColumnType instance;
            long bits = 0L;
            if (object instanceof Column.ColumnType) {
                instance = (Column.ColumnType)object;
                this.isFrozen(instance.isFrozen());
                if ((bits & 1L) == 0L) {
                    this.addAllParameters(instance.parameters());
                    bits |= 1L;
                }
            }
            if (object instanceof ParameterizedType) {
                instance = (ParameterizedType)object;
                if ((bits & 1L) == 0L) {
                    this.addAllParameters(((ParameterizedType)instance).parameters());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder isFrozen(boolean isFrozen) {
            this.isFrozen = isFrozen;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addParameters(Column.ColumnType element) {
            this.parameters.add(Objects.requireNonNull(element, "parameters element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParameters(Column.ColumnType ... elements) {
            for (Column.ColumnType element : elements) {
                this.parameters.add(Objects.requireNonNull(element, "parameters element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parameters(Iterable<? extends Column.ColumnType> elements) {
            this.parameters.clear();
            return this.addAllParameters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllParameters(Iterable<? extends Column.ColumnType> elements) {
            for (Column.ColumnType columnType : elements) {
                this.parameters.add(Objects.requireNonNull(columnType, "parameters element"));
            }
            return this;
        }

        @Override
        public ImmutableListType build() {
            return new ImmutableListType(this);
        }

        private boolean isFrozenIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

