/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.schema.CollectionIndexingType;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.QualifiedSchemaEntity;
import io.stargate.db.schema.SchemaEntity;
import io.stargate.db.schema.SecondaryIndex;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SecondaryIndex", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableSecondaryIndex
extends SecondaryIndex {
    private final String name;
    private final String keyspace;
    @Nullable
    private final Column column;
    private final CollectionIndexingType indexingType;
    private final boolean isCustom;
    @Nullable
    private final String indexingClass;
    @Nullable
    private final Map<String, String> indexingOptions;
    private final int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long CQL_NAME_LAZY_INIT_BIT = 1L;
    private transient String cqlName;
    private static final long CQL_KEYSPACE_LAZY_INIT_BIT = 2L;
    private transient String cqlKeyspace;
    private static final long CQL_QUALIFIED_NAME_LAZY_INIT_BIT = 4L;
    private transient String cqlQualifiedName;
    private static final long serialVersionUID = 424886903165529554L;

    private ImmutableSecondaryIndex(Builder builder) {
        this.name = builder.name;
        this.keyspace = builder.keyspace;
        this.column = builder.column;
        this.indexingType = builder.indexingType;
        this.indexingClass = builder.indexingClass;
        this.indexingOptions = builder.indexingOptions == null ? null : ImmutableSecondaryIndex.createUnmodifiableMap(false, false, builder.indexingOptions);
        this.isCustom = builder.isCustomIsSet() ? builder.isCustom : super.isCustom();
        this.hashCode = this.computeHashCode();
    }

    private ImmutableSecondaryIndex(String name, String keyspace, @Nullable Column column, CollectionIndexingType indexingType, boolean isCustom, @Nullable String indexingClass, @Nullable Map<String, String> indexingOptions) {
        this.name = name;
        this.keyspace = keyspace;
        this.column = column;
        this.indexingType = indexingType;
        this.isCustom = isCustom;
        this.indexingClass = indexingClass;
        this.indexingOptions = indexingOptions;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String keyspace() {
        return this.keyspace;
    }

    @Override
    @Nullable
    public Column column() {
        return this.column;
    }

    @Override
    public CollectionIndexingType indexingType() {
        return this.indexingType;
    }

    @Override
    public boolean isCustom() {
        return this.isCustom;
    }

    @Override
    @Nullable
    public String indexingClass() {
        return this.indexingClass;
    }

    @Override
    @Nullable
    public Map<String, String> indexingOptions() {
        return this.indexingOptions;
    }

    public final ImmutableSecondaryIndex withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableSecondaryIndex(newValue, this.keyspace, this.column, this.indexingType, this.isCustom, this.indexingClass, this.indexingOptions);
    }

    public final ImmutableSecondaryIndex withKeyspace(String value) {
        String newValue = Objects.requireNonNull(value, "keyspace");
        if (this.keyspace.equals(newValue)) {
            return this;
        }
        return new ImmutableSecondaryIndex(this.name, newValue, this.column, this.indexingType, this.isCustom, this.indexingClass, this.indexingOptions);
    }

    public final ImmutableSecondaryIndex withColumn(@Nullable Column value) {
        if (this.column == value) {
            return this;
        }
        return new ImmutableSecondaryIndex(this.name, this.keyspace, value, this.indexingType, this.isCustom, this.indexingClass, this.indexingOptions);
    }

    public final ImmutableSecondaryIndex withIndexingType(CollectionIndexingType value) {
        if (this.indexingType == value) {
            return this;
        }
        CollectionIndexingType newValue = Objects.requireNonNull(value, "indexingType");
        return new ImmutableSecondaryIndex(this.name, this.keyspace, this.column, newValue, this.isCustom, this.indexingClass, this.indexingOptions);
    }

    public final ImmutableSecondaryIndex withIsCustom(boolean value) {
        if (this.isCustom == value) {
            return this;
        }
        return new ImmutableSecondaryIndex(this.name, this.keyspace, this.column, this.indexingType, value, this.indexingClass, this.indexingOptions);
    }

    public final ImmutableSecondaryIndex withIndexingClass(@Nullable String value) {
        if (Objects.equals(this.indexingClass, value)) {
            return this;
        }
        return new ImmutableSecondaryIndex(this.name, this.keyspace, this.column, this.indexingType, this.isCustom, value, this.indexingOptions);
    }

    public final ImmutableSecondaryIndex withIndexingOptions(@Nullable Map<String, ? extends String> entries) {
        if (this.indexingOptions == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableSecondaryIndex.createUnmodifiableMap(true, false, entries);
        return new ImmutableSecondaryIndex(this.name, this.keyspace, this.column, this.indexingType, this.isCustom, this.indexingClass, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecondaryIndex && this.equalTo((ImmutableSecondaryIndex)another);
    }

    private boolean equalTo(ImmutableSecondaryIndex another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.name.equals(another.name) && this.keyspace.equals(another.keyspace) && Objects.equals(this.column, another.column) && this.indexingType.equals(another.indexingType) && this.isCustom == another.isCustom && Objects.equals(this.indexingClass, another.indexingClass) && Objects.equals(this.indexingOptions, another.indexingOptions);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.keyspace.hashCode();
        h += (h << 5) + Objects.hashCode(this.column);
        h += (h << 5) + this.indexingType.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isCustom);
        h += (h << 5) + Objects.hashCode(this.indexingClass);
        h += (h << 5) + Objects.hashCode(this.indexingOptions);
        return h;
    }

    public String toString() {
        return "SecondaryIndex{name=" + this.name + ", keyspace=" + this.keyspace + ", column=" + this.column + ", indexingType=" + this.indexingType + ", isCustom=" + this.isCustom + ", indexingClass=" + this.indexingClass + ", indexingOptions=" + this.indexingOptions + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String cqlName() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableSecondaryIndex immutableSecondaryIndex = this;
            synchronized (immutableSecondaryIndex) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.cqlName = Objects.requireNonNull(super.cqlName(), "cqlName");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.cqlName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String cqlKeyspace() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableSecondaryIndex immutableSecondaryIndex = this;
            synchronized (immutableSecondaryIndex) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.cqlKeyspace = Objects.requireNonNull(super.cqlKeyspace(), "cqlKeyspace");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.cqlKeyspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String cqlQualifiedName() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableSecondaryIndex immutableSecondaryIndex = this;
            synchronized (immutableSecondaryIndex) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.cqlQualifiedName = Objects.requireNonNull(super.cqlQualifiedName(), "cqlQualifiedName");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.cqlQualifiedName;
    }

    public static ImmutableSecondaryIndex copyOf(SecondaryIndex instance) {
        if (instance instanceof ImmutableSecondaryIndex) {
            return (ImmutableSecondaryIndex)instance;
        }
        return ImmutableSecondaryIndex.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return new ImmutableSecondaryIndex(this.name, this.keyspace, this.column, this.indexingType, this.isCustom, this.indexingClass, this.indexingOptions);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="SecondaryIndex", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_KEYSPACE = 2L;
        private static final long INIT_BIT_INDEXING_TYPE = 4L;
        private static final long OPT_BIT_IS_CUSTOM = 1L;
        private long initBits = 7L;
        private long optBits;
        @Nullable
        private String name;
        @Nullable
        private String keyspace;
        @Nullable
        private Column column;
        @Nullable
        private CollectionIndexingType indexingType;
        private boolean isCustom;
        @Nullable
        private String indexingClass;
        private Map<String, String> indexingOptions = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SchemaEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(SecondaryIndex instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(QualifiedSchemaEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SchemaEntity instance;
            if (object instanceof SchemaEntity) {
                instance = (SchemaEntity)object;
                this.name(instance.name());
            }
            if (object instanceof SecondaryIndex) {
                Map<String, String> indexingOptionsValue;
                instance = (SecondaryIndex)object;
                Column columnValue = ((SecondaryIndex)instance).column();
                if (columnValue != null) {
                    this.column(columnValue);
                }
                this.isCustom(((SecondaryIndex)instance).isCustom());
                String indexingClassValue = ((SecondaryIndex)instance).indexingClass();
                if (indexingClassValue != null) {
                    this.indexingClass(indexingClassValue);
                }
                if ((indexingOptionsValue = ((SecondaryIndex)instance).indexingOptions()) != null) {
                    this.putAllIndexingOptions(indexingOptionsValue);
                }
                this.indexingType(((SecondaryIndex)instance).indexingType());
            }
            if (object instanceof QualifiedSchemaEntity) {
                instance = (QualifiedSchemaEntity)object;
                this.keyspace(instance.keyspace());
            }
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyspace(String keyspace) {
            this.keyspace = Objects.requireNonNull(keyspace, "keyspace");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder column(@Nullable Column column) {
            this.column = column;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder indexingType(CollectionIndexingType indexingType) {
            this.indexingType = Objects.requireNonNull(indexingType, "indexingType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isCustom(boolean isCustom) {
            this.isCustom = isCustom;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder indexingClass(@Nullable String indexingClass) {
            this.indexingClass = indexingClass;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putIndexingOptions(String key, String value) {
            if (this.indexingOptions == null) {
                this.indexingOptions = new LinkedHashMap<String, String>();
            }
            this.indexingOptions.put(Objects.requireNonNull(key, "indexingOptions key"), Objects.requireNonNull(value, "indexingOptions value"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putIndexingOptions(Map.Entry<String, ? extends String> entry) {
            if (this.indexingOptions == null) {
                this.indexingOptions = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.indexingOptions.put(Objects.requireNonNull(k, "indexingOptions key"), Objects.requireNonNull(v, "indexingOptions value"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder indexingOptions(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.indexingOptions = null;
                return this;
            }
            this.indexingOptions = new LinkedHashMap<String, String>();
            return this.putAllIndexingOptions(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllIndexingOptions(Map<String, ? extends String> entries) {
            if (this.indexingOptions == null) {
                this.indexingOptions = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.indexingOptions.put(Objects.requireNonNull(k, "indexingOptions key"), Objects.requireNonNull(v, "indexingOptions value"));
            }
            return this;
        }

        public ImmutableSecondaryIndex build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSecondaryIndex(this);
        }

        private boolean isCustomIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("keyspace");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("indexingType");
            }
            return "Cannot build SecondaryIndex, some of required attributes are not set " + attributes;
        }
    }
}

