/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import io.stargate.db.schema.AbstractTable;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableMaterializedView;
import io.stargate.db.schema.Index;
import org.immutables.value.Value;

@Value.Immutable(prehash=true)
public abstract class MaterializedView
extends AbstractTable
implements Index {
    private static final long serialVersionUID = -2999120284516448661L;

    public static MaterializedView create(String keyspace, String name, Iterable<Column> columns) {
        columns.forEach(c -> Preconditions.checkState(c.kind() != null, "Column reference may not be used %s", (Object)c.name()));
        return ImmutableMaterializedView.builder().keyspace(keyspace).name(name).addAllColumns(columns).build();
    }

    public static MaterializedView reference(String keyspace, String name) {
        return ImmutableMaterializedView.builder().keyspace(keyspace).name(name).addColumns(new Column[0]).build();
    }

    @Override
    public int priority() {
        return 1;
    }

    @Override
    public String indexTypeName() {
        return "Materialized view";
    }
}

