/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import java.math.BigDecimal;
import java.math.BigInteger;

class NumberCoercion {
    NumberCoercion() {
    }

    private static byte toByteExact(short value) {
        byte narrowed = (byte)value;
        if (narrowed != value) {
            throw new ArithmeticException("short out of byte range");
        }
        return narrowed;
    }

    private static byte toByteExact(int value) {
        byte narrowed = (byte)value;
        if (narrowed != value) {
            throw new ArithmeticException("int out of byte range");
        }
        return narrowed;
    }

    private static byte toByteExact(long value) {
        byte narrowed = (byte)value;
        if ((long)narrowed != value) {
            throw new ArithmeticException("long out of byte range");
        }
        return narrowed;
    }

    private static byte toByteExact(double value) {
        byte narrowed = (byte)value;
        if ((double)narrowed != value) {
            throw new ArithmeticException("double out of byte range");
        }
        return narrowed;
    }

    private static byte toByteExact(float value) {
        byte narrowed = (byte)value;
        if ((float)narrowed != value) {
            throw new ArithmeticException("float out of byte range");
        }
        return narrowed;
    }

    private static short toShortExact(int value) {
        short narrowed = (short)value;
        if (narrowed != value) {
            throw new ArithmeticException("int out of short range");
        }
        return narrowed;
    }

    private static short toShortExact(long value) {
        short narrowed = (short)value;
        if ((long)narrowed != value) {
            throw new ArithmeticException("long out of short range");
        }
        return narrowed;
    }

    private static short toShortExact(double value) {
        short narrowed = (short)value;
        if ((double)narrowed != value) {
            throw new ArithmeticException("double out of short range");
        }
        return narrowed;
    }

    private static short toShortExact(float value) {
        short narrowed = (short)value;
        if ((float)narrowed != value) {
            throw new ArithmeticException("float out of short range");
        }
        return narrowed;
    }

    private static int toIntExact(long value) {
        int narrowed = (int)value;
        if ((long)narrowed != value) {
            throw new ArithmeticException("long out of int range");
        }
        return narrowed;
    }

    private static float toFloatExact(double value) {
        float narrowed = (float)value;
        if (Double.compare(narrowed, value) != 0) {
            throw new ArithmeticException("double out of float range");
        }
        return narrowed;
    }

    private static float toFloatExact(BigDecimal value) {
        float narrowed = value.floatValue();
        if (BigDecimal.valueOf(narrowed).compareTo(value) != 0) {
            throw new ArithmeticException("BigDecimal out of float range");
        }
        return narrowed;
    }

    private static double toDoubleExact(BigDecimal value) {
        double narrowed = value.doubleValue();
        if (BigDecimal.valueOf(narrowed).compareTo(value) != 0) {
            throw new ArithmeticException("BigDecimal out of double range");
        }
        return narrowed;
    }

    private static boolean isFloat(Object value) {
        return value instanceof Float;
    }

    private static boolean isDouble(Object value) {
        return value instanceof Double;
    }

    private static boolean isBigDecimal(Object value) {
        return value instanceof BigDecimal;
    }

    private static boolean isByte(Object value) {
        return value instanceof Byte;
    }

    private static boolean isShort(Object value) {
        return value instanceof Short;
    }

    private static boolean isInt(Object value) {
        return value instanceof Integer;
    }

    private static boolean isLong(Object value) {
        return value instanceof Long;
    }

    private static boolean isBigInt(Object value) {
        return value instanceof BigInteger;
    }

    private static BigInteger toBigInteger(Object value) {
        if (NumberCoercion.isBigInt(value)) {
            return (BigInteger)value;
        }
        if (NumberCoercion.isBigDecimal(value)) {
            return ((BigDecimal)value).toBigIntegerExact();
        }
        if (NumberCoercion.isLong(value)) {
            return BigInteger.valueOf((Long)value);
        }
        if (NumberCoercion.isDouble(value)) {
            return BigInteger.valueOf(((Double)value).longValue());
        }
        if (NumberCoercion.isInt(value)) {
            return BigInteger.valueOf(((Integer)value).intValue());
        }
        if (NumberCoercion.isFloat(value)) {
            return BigInteger.valueOf(((Float)value).longValue());
        }
        if (NumberCoercion.isShort(value)) {
            return BigInteger.valueOf(((Short)value).shortValue());
        }
        return BigInteger.valueOf(((Byte)value).byteValue());
    }

    private static long toLong(Object value) {
        if (NumberCoercion.isBigInt(value)) {
            return ((BigInteger)value).longValueExact();
        }
        if (NumberCoercion.isBigDecimal(value)) {
            return ((BigDecimal)value).longValueExact();
        }
        if (NumberCoercion.isLong(value)) {
            return (Long)value;
        }
        if (NumberCoercion.isDouble(value)) {
            return ((Double)value).longValue();
        }
        if (NumberCoercion.isInt(value)) {
            return ((Integer)value).intValue();
        }
        if (NumberCoercion.isFloat(value)) {
            return ((Float)value).longValue();
        }
        if (NumberCoercion.isShort(value)) {
            return ((Short)value).shortValue();
        }
        return ((Byte)value).byteValue();
    }

    private static int toInt(Object value) {
        if (NumberCoercion.isBigInt(value)) {
            return ((BigInteger)value).intValueExact();
        }
        if (NumberCoercion.isBigDecimal(value)) {
            return ((BigDecimal)value).intValueExact();
        }
        if (NumberCoercion.isLong(value)) {
            return NumberCoercion.toIntExact((Long)value);
        }
        if (NumberCoercion.isDouble(value)) {
            return ((Double)value).intValue();
        }
        if (NumberCoercion.isInt(value)) {
            return (Integer)value;
        }
        if (NumberCoercion.isFloat(value)) {
            return ((Float)value).intValue();
        }
        if (NumberCoercion.isShort(value)) {
            return ((Short)value).shortValue();
        }
        return ((Byte)value).byteValue();
    }

    private static short toShort(Object value) {
        if (NumberCoercion.isBigInt(value)) {
            return ((BigInteger)value).shortValueExact();
        }
        if (NumberCoercion.isBigDecimal(value)) {
            return ((BigDecimal)value).shortValueExact();
        }
        if (NumberCoercion.isLong(value)) {
            return NumberCoercion.toShortExact((Long)value);
        }
        if (NumberCoercion.isDouble(value)) {
            return NumberCoercion.toShortExact((Double)value);
        }
        if (NumberCoercion.isInt(value)) {
            return NumberCoercion.toShortExact((Integer)value);
        }
        if (NumberCoercion.isFloat(value)) {
            return NumberCoercion.toShortExact(((Float)value).floatValue());
        }
        if (NumberCoercion.isShort(value)) {
            return (Short)value;
        }
        return ((Byte)value).byteValue();
    }

    private static byte toByte(Object value) {
        if (NumberCoercion.isBigInt(value)) {
            return ((BigInteger)value).byteValueExact();
        }
        if (NumberCoercion.isBigDecimal(value)) {
            return ((BigDecimal)value).byteValueExact();
        }
        if (NumberCoercion.isLong(value)) {
            return NumberCoercion.toByteExact((Long)value);
        }
        if (NumberCoercion.isDouble(value)) {
            return NumberCoercion.toByteExact((Double)value);
        }
        if (NumberCoercion.isInt(value)) {
            return NumberCoercion.toByteExact((Integer)value);
        }
        if (NumberCoercion.isFloat(value)) {
            return NumberCoercion.toByteExact(((Float)value).floatValue());
        }
        if (NumberCoercion.isShort(value)) {
            return NumberCoercion.toByteExact((Short)value);
        }
        return (Byte)value;
    }

    private static BigDecimal toBigDecimal(Object value) {
        if (NumberCoercion.isBigDecimal(value)) {
            return (BigDecimal)value;
        }
        if (NumberCoercion.isDouble(value)) {
            return BigDecimal.valueOf((Double)value);
        }
        return BigDecimal.valueOf(((Float)value).floatValue());
    }

    private static double toDouble(Object value) {
        if (NumberCoercion.isBigDecimal(value)) {
            return NumberCoercion.toDoubleExact((BigDecimal)value);
        }
        if (NumberCoercion.isDouble(value)) {
            return (Double)value;
        }
        return ((Float)value).floatValue();
    }

    private static float toFloat(Object value) {
        if (NumberCoercion.isBigDecimal(value)) {
            return NumberCoercion.toFloatExact((BigDecimal)value);
        }
        if (NumberCoercion.isDouble(value)) {
            return NumberCoercion.toFloatExact((Double)value);
        }
        return ((Float)value).floatValue();
    }

    private static boolean isDecimalNumber(Object value) {
        return NumberCoercion.isBigDecimal(value) && ((BigDecimal)value).stripTrailingZeros().scale() > 0 || NumberCoercion.isDouble(value) && (Double)value % 1.0 > 0.0 || NumberCoercion.isFloat(value) && ((Float)value).floatValue() % 1.0f > 0.0f;
    }

    private static boolean isNaturalNumber(Object value) {
        return NumberCoercion.isBigInt(value) || NumberCoercion.isLong(value) || NumberCoercion.isInt(value) || NumberCoercion.isShort(value) || NumberCoercion.isByte(value);
    }

    public static Result coerceToColumnType(Class<?> columnType, Object value) {
        if (!(value instanceof Number)) {
            return Result.coercionFailed(value);
        }
        if (NumberCoercion.columnTypeRequiresNaturalNumber(columnType) && NumberCoercion.isDecimalNumber(value)) {
            return Result.coercionFailed(value);
        }
        if (NumberCoercion.columnTypeRequiresDecimalNumber(columnType) && NumberCoercion.isNaturalNumber(value)) {
            return Result.coercionFailed(value);
        }
        if (NumberCoercion.columnTypeIsBigInteger(columnType)) {
            return Result.coercionOk(NumberCoercion.toBigInteger(value));
        }
        if (NumberCoercion.columnTypeIsLong(columnType)) {
            return Result.coercionOk(NumberCoercion.toLong(value));
        }
        if (NumberCoercion.columnTypeIsInt(columnType)) {
            return Result.coercionOk(NumberCoercion.toInt(value));
        }
        if (NumberCoercion.columnTypeIsShort(columnType)) {
            return Result.coercionOk(NumberCoercion.toShort(value));
        }
        if (NumberCoercion.columnTypeIsByte(columnType)) {
            return Result.coercionOk(NumberCoercion.toByte(value));
        }
        if (NumberCoercion.columnTypeIsBigDecimal(columnType)) {
            return Result.coercionOk(NumberCoercion.toBigDecimal(value));
        }
        if (NumberCoercion.columnTypeIsDouble(columnType)) {
            return Result.coercionOk(NumberCoercion.toDouble(value));
        }
        if (NumberCoercion.columnTypeIsFloat(columnType)) {
            return Result.coercionOk(Float.valueOf(NumberCoercion.toFloat(value)));
        }
        return Result.coercionFailed(value);
    }

    private static boolean columnTypeRequiresNaturalNumber(Class<?> columnType) {
        return NumberCoercion.columnTypeIsBigInteger(columnType) || NumberCoercion.columnTypeIsLong(columnType) || NumberCoercion.columnTypeIsInt(columnType) || NumberCoercion.columnTypeIsShort(columnType) || NumberCoercion.columnTypeIsByte(columnType);
    }

    private static boolean columnTypeRequiresDecimalNumber(Class<?> columnType) {
        return NumberCoercion.columnTypeIsBigDecimal(columnType) || NumberCoercion.columnTypeIsDouble(columnType) || NumberCoercion.columnTypeIsFloat(columnType);
    }

    private static boolean columnTypeIsFloat(Class<?> columnType) {
        return Float.class.equals(columnType);
    }

    private static boolean columnTypeIsDouble(Class<?> columnType) {
        return Double.class.equals(columnType);
    }

    private static boolean columnTypeIsBigDecimal(Class<?> columnType) {
        return BigDecimal.class.equals(columnType);
    }

    private static boolean columnTypeIsByte(Class<?> columnType) {
        return Byte.class.equals(columnType);
    }

    private static boolean columnTypeIsShort(Class<?> columnType) {
        return Short.class.equals(columnType);
    }

    private static boolean columnTypeIsInt(Class<?> columnType) {
        return Integer.class.equals(columnType);
    }

    private static boolean columnTypeIsLong(Class<?> columnType) {
        return Long.class.equals(columnType);
    }

    private static boolean columnTypeIsBigInteger(Class<?> columnType) {
        return BigInteger.class.equals(columnType);
    }

    static class Result {
        final boolean columnTypeAcceptsValue;
        final Object validatedValue;

        Result(boolean columnTypeAcceptsValue, Object validatedValue) {
            this.columnTypeAcceptsValue = columnTypeAcceptsValue;
            this.validatedValue = validatedValue;
        }

        public static Result coercionFailed(Object validatedValue) {
            return new Result(false, validatedValue);
        }

        public static Result coercionOk(Object validatedValue) {
            return new Result(true, validatedValue);
        }

        public boolean columnTypeAcceptsValue() {
            return this.columnTypeAcceptsValue;
        }

        public Object getValidatedValue() {
            return this.validatedValue;
        }
    }
}

