/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableCollectionIndexingType;
import io.stargate.db.schema.ImmutableColumn;
import io.stargate.db.schema.ImmutableKeyspace;
import io.stargate.db.schema.ImmutableUserDefinedType;
import io.stargate.db.schema.Index;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.MaterializedView;
import io.stargate.db.schema.Schema;
import io.stargate.db.schema.SecondaryIndex;
import io.stargate.db.schema.Table;
import io.stargate.db.schema.UserDefinedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SchemaBuilderImpl {
    private Set<Keyspace> keyspaces = new LinkedHashSet<Keyspace>();
    private Set<Table> tables = new LinkedHashSet<Table>();
    private Set<Column> columns = new LinkedHashSet<Column>();
    private Set<Column> materializedViewColumns = new LinkedHashSet<Column>();
    private Set<Index> indexes = new LinkedHashSet<Index>();
    private String keyspaceName;
    private String tableName;
    private String materializedViewName;
    private Column secondaryIndexColumn;
    private String secondaryIndexName;
    private Optional<Consumer<Schema>> callback;
    private String udtTypeName;
    private Set<UserDefinedType> udts = new LinkedHashSet<UserDefinedType>();
    private boolean indexKeys;
    private boolean indexValues;
    private boolean indexEntries;
    private boolean indexFull;
    private String indexClass;
    private Map<String, String> indexOptions = new HashMap<String, String>();
    private List<Column> fromColumns = new ArrayList<Column>();
    private List<Column> toColumns = new ArrayList<Column>();
    private Map<String, String> replication = Collections.emptyMap();
    private Optional<Boolean> durableWrites = Optional.empty();
    private boolean finishingLast = false;

    public SchemaBuilderImpl(Optional<Consumer<Schema>> callback) {
        this.callback = callback;
    }

    public void keyspace(String name) {
        if (this.keyspaceName != null) {
            this.table(null);
            this.keyspaces.add(Keyspace.create(this.keyspaceName, this.tables, this.udts, this.replication, this.durableWrites));
            this.tables.clear();
            this.udts.clear();
            this.replication = Collections.emptyMap();
            this.durableWrites = Optional.empty();
        }
        this.keyspaceName = name;
    }

    public void type(String typeName) {
        this.finishLast();
        this.udtTypeName = typeName;
    }

    private void finishLastUDT() {
        if (null != this.udtTypeName) {
            LinkedHashSet cols = new LinkedHashSet(this.columns.size());
            this.columns.stream().forEach(c -> cols.add(this.maybeFreezeIfComplexSubtype((Column)c)));
            this.udts.add(ImmutableUserDefinedType.builder().keyspace(this.keyspaceName).name(this.udtTypeName).columns(cols).build().dereference(this.udtKeyspace()));
            this.columns.clear();
            this.udtTypeName = null;
        }
    }

    private Column maybeFreezeIfComplexSubtype(Column column) {
        if (column.type().isComplexType() && !column.type().isFrozen()) {
            return ImmutableColumn.builder().from(column).type(column.type().frozen()).build();
        }
        return column;
    }

    private ImmutableKeyspace udtKeyspace() {
        return ImmutableKeyspace.builder().name(this.keyspaceName).userDefinedTypes(this.udts).build();
    }

    public void table(String name) {
        this.finishLast();
        if (this.tableName != null) {
            Table table = Table.create(this.keyspaceName, this.tableName, ImmutableList.copyOf(this.columns), ImmutableList.copyOf(this.indexes));
            Preconditions.checkArgument(!table.primaryKeyColumns().isEmpty(), "Table '%s' must have at least one primary key column", (Object)table.name());
            this.tables.add(table);
            this.indexes.clear();
            this.columns.clear();
        }
        this.tableName = name;
    }

    public void finishLast() {
        if (!this.finishingLast) {
            try {
                this.finishingLast = true;
                this.finishLastUDT();
                this.finishLastSecondaryIndex();
                this.finishLastMaterializedView();
            }
            finally {
                this.finishingLast = false;
            }
        }
    }

    public void column(String name, Column.ColumnType type, Column.Kind kind) {
        this.column(name, type, kind, kind == Column.Kind.Clustering ? Column.Order.ASC : null);
    }

    public void column(String name, Column.ColumnType type, Column.Kind kind, Column.Order order) {
        this.checkIndexOnColumn(name);
        this.checkMvOnColumn(name);
        this.columns.add(ImmutableColumn.builder().keyspace(this.keyspaceName).table(this.tableName).name(name).type(type.dereference(this.udtKeyspace())).kind(kind).order(order).build());
    }

    public void column(String name, Class type, Column.Kind kind) {
        this.column(name, type, kind, kind == Column.Kind.Clustering ? Column.Order.ASC : null);
    }

    public void column(String name, Class type, Column.Kind kind, Column.Order order) {
        this.checkIndexOnColumn(name);
        this.checkMvOnColumn(name);
        this.columns.add(ImmutableColumn.builder().keyspace(this.keyspaceName).table(this.tableName).name(name).type(type).kind(kind).order(order).build());
    }

    public void column(String name, Column.Kind kind) {
        this.checkIndexOnColumn(name);
        Preconditions.checkState(this.materializedViewName != null, "This overload of 'column' can only be used with materialized views");
        Column.Order order = kind == Column.Kind.Clustering ? Column.Order.ASC : null;
        this.materializedViewColumns.add(ImmutableColumn.builder().keyspace(this.keyspaceName).table(this.tableName).name(name).kind(kind).order(order).build());
    }

    public void column(String name, Column.Kind kind, Column.Order order) {
        this.checkIndexOnColumn(name);
        Preconditions.checkState(this.materializedViewName != null, "This overload of 'column' can only be used with materialized views");
        Preconditions.checkArgument(kind == Column.Kind.Clustering, "Order can only be specified for clustering columns");
        Preconditions.checkArgument(order != null, "Clustering order may not be null");
        this.materializedViewColumns.add(ImmutableColumn.builder().keyspace(this.keyspaceName).table(this.tableName).name(name).kind(kind).order(order).build());
    }

    public void column(String name, Column.ColumnType type) {
        this.checkIndexOnColumn(name);
        this.checkMvOnColumn(name);
        if (type.isUserDefined()) {
            Preconditions.checkArgument(this.udts.stream().anyMatch(u -> u.name().equals(type.name())), "User defined type '%s' does not exist in keyspace '%s'", (Object)type.name(), (Object)this.keyspaceName);
        }
        Preconditions.checkState(this.materializedViewName == null && this.secondaryIndexName == null, "This overload of 'column' can only be used with tables or udts");
        this.columns.add(ImmutableColumn.builder().keyspace(this.keyspaceName).table(this.tableName).name(name).type(type.dereference(this.udtKeyspace())).kind(Column.Kind.Regular).build());
    }

    public void column(String name, Class<?> type) {
        this.checkIndexOnColumn(name);
        this.checkMvOnColumn(name);
        Preconditions.checkState(this.materializedViewName == null && this.secondaryIndexName == null, "This overload of 'column' can only be used with tables");
        this.columns.add(ImmutableColumn.builder().keyspace(this.keyspaceName).table(this.tableName).name(name).type(type).kind(Column.Kind.Regular).build());
    }

    public void column(String name) {
        Preconditions.checkState(this.materializedViewName != null || this.secondaryIndexName != null, "This overload of 'column' can only be used with materialized views or secondary indexes");
        if (this.secondaryIndexName != null) {
            this.secondaryIndexColumn = Column.reference(name);
        } else if (this.materializedViewName != null) {
            this.materializedViewColumns.add(ImmutableColumn.builder().keyspace(this.keyspaceName).table(this.tableName).name(name).kind(Column.Kind.Regular).build());
        }
    }

    public void secondaryIndex(String name) {
        this.finishLast();
        this.secondaryIndexColumn = null;
        this.secondaryIndexName = name;
    }

    public void materializedView(String name) {
        this.finishLast();
        this.materializedViewName = name;
    }

    public void indexKeys() {
        this.indexKeys = true;
    }

    public void indexValues() {
        this.indexValues = true;
    }

    public void indexEntries() {
        this.indexEntries = true;
    }

    public void indexFull() {
        this.indexFull = true;
    }

    public void indexClass(String name) {
        this.indexClass = name;
    }

    public void indexOptions(Map<String, String> options) {
        this.indexOptions = options;
    }

    public void from(String fromVertex) {
    }

    public void to(String toVertex) {
    }

    public void fromColumn(String ... columns) {
        for (String column : columns) {
            this.fromColumns.add(ImmutableColumn.builder().from(this.columnExistsAndIsPrimaryKey(column).get()).build());
        }
    }

    public void toColumn(String ... columns) {
        for (String column : columns) {
            this.toColumns.add(ImmutableColumn.builder().from(this.columnExistsAndIsPrimaryKey(column).get()).build());
        }
    }

    public void fromColumn(List<String> columns) {
        this.fromColumn(columns.toArray(new String[0]));
    }

    public void toColumn(List<String> columns) {
        this.toColumn(columns.toArray(new String[0]));
    }

    public void withReplication(Map<String, String> replication) {
        this.replication = replication;
    }

    public void andDurableWrites(boolean durableWrites) {
        this.durableWrites = Optional.of(durableWrites);
    }

    private Optional<Column> columnExistsAndIsPrimaryKey(String name) {
        Optional<Column> column = this.columns.stream().filter(c -> c.name().equals(name)).findFirst();
        Preconditions.checkArgument(column.isPresent(), "Column '%s' does not exist in table '%s'", (Object)name, (Object)this.tableName);
        Preconditions.checkArgument(column.get().isPrimaryKeyComponent(), "Column '%s' is not a primary key in table '%s'", (Object)name, (Object)this.tableName);
        return column;
    }

    private void checkMvOnColumn(String columnName) {
        if (this.materializedViewName != null) {
            throw new IllegalStateException(String.format("Invalid usage of materialized view '%s' on column '%s'", this.materializedViewName, columnName));
        }
    }

    private void checkIndexOnColumn(String columnName) {
        if (this.secondaryIndexName != null) {
            throw new IllegalStateException(String.format("Invalid usage of secondary index '%s' on column '%s'", this.secondaryIndexName, columnName));
        }
    }

    private void finishLastSecondaryIndex() {
        if (this.secondaryIndexName != null) {
            Preconditions.checkArgument(this.secondaryIndexColumn != null, "No column is referenced for secondary index");
            Optional<Column> sourceColumn = this.columns.stream().filter(c -> c.name().equals(this.secondaryIndexColumn.name())).findFirst();
            Preconditions.checkArgument(sourceColumn.isPresent(), "Secondary index references unknown column '%s'", (Object)this.secondaryIndexColumn.name());
            if (sourceColumn.get().isFrozenCollection()) {
                Preconditions.checkArgument(this.indexFull, "Only indexFull() is supported on frozen collection '%s'", (Object)sourceColumn.get().name());
            } else if (sourceColumn.get().ofTypeListOrSet()) {
                Preconditions.checkArgument(!this.indexFull, "indexFull() cannot be applied to column '%s'. It can only be used on a frozen collection", (Object)sourceColumn.get().name());
                Preconditions.checkArgument(!this.indexKeys, "indexKeys() cannot be applied to column '%s'. It can only be used on a Map", (Object)sourceColumn.get().name());
                Preconditions.checkArgument(!this.indexEntries, "indexEntries() cannot be applied to column '%s'. It can only be used on a Map", (Object)sourceColumn.get().name());
                this.indexValues = true;
            } else if (sourceColumn.get().ofTypeMap()) {
                Preconditions.checkArgument(!this.indexFull, "indexFull() cannot be applied to column '%s'. It can only be used on a frozen collection", (Object)sourceColumn.get().name());
                if (!(this.indexEntries || this.indexKeys || this.indexValues)) {
                    this.indexValues = true;
                }
            }
            this.indexes.add(SecondaryIndex.create(this.keyspaceName, this.secondaryIndexName, sourceColumn.get(), ImmutableCollectionIndexingType.builder().indexEntries(this.indexEntries).indexKeys(this.indexKeys).indexValues(this.indexValues).indexFull(this.indexFull).build(), this.indexClass, this.indexOptions));
            this.secondaryIndexColumn = null;
            this.secondaryIndexName = null;
            this.indexKeys = false;
            this.indexValues = false;
            this.indexEntries = false;
            this.indexFull = false;
            this.indexClass = null;
            if (this.indexOptions != null) {
                this.indexOptions.clear();
            }
        }
    }

    private void finishLastMaterializedView() {
        if (this.materializedViewName != null) {
            this.finishLast();
            Preconditions.checkArgument(!this.materializedViewColumns.isEmpty(), "No column is referenced for materialized view");
            ArrayList<ImmutableColumn> columnReferences = new ArrayList<ImmutableColumn>();
            for (Column col : this.materializedViewColumns) {
                Optional<Column> sourceColumn = this.columns.stream().filter(c -> c.name().equals(col.name())).findFirst();
                Preconditions.checkArgument(sourceColumn.isPresent(), "Materialized view references unknown column '%s'", (Object)col.name());
                columnReferences.add(ImmutableColumn.builder().name(sourceColumn.get().name()).type(sourceColumn.get().type()).kind(col.kind()).order(col.order()).build());
            }
            Set columnNames = this.materializedViewColumns.stream().map(c -> c.name()).collect(Collectors.toSet());
            Set sourceTablePkColumnNames = this.columns.stream().filter(c -> c.kind() == Column.Kind.PartitionKey || c.kind() == Column.Kind.Clustering).map(c -> c.name()).collect(Collectors.toSet());
            Sets.SetView missingColumns = Sets.difference(sourceTablePkColumnNames, columnNames);
            Preconditions.checkArgument(missingColumns.isEmpty(), "Materialized view was missing PK columns %s", missingColumns);
            this.indexes.add(MaterializedView.create(this.keyspaceName, this.materializedViewName, ImmutableList.copyOf(columnReferences)));
            this.materializedViewColumns.clear();
            this.materializedViewName = null;
        }
    }

    public Schema build() {
        this.finishLastUDT();
        this.keyspace(null);
        Schema schema = Schema.create(ImmutableSet.copyOf(this.keyspaces));
        this.callback.ifPresent(c -> c.accept(schema));
        return schema;
    }
}

