/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.context;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.context.NettyOptions;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.internal.core.util.concurrent.PromiseCombiner;
import com.datastax.oss.driver.shaded.guava.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.time.Duration;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class DefaultNettyOptions
implements NettyOptions {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNettyOptions.class);
    private final DriverExecutionProfile config;
    private final EventLoopGroup ioEventLoopGroup;
    private final EventLoopGroup adminEventLoopGroup;
    private final int ioShutdownQuietPeriod;
    private final int ioShutdownTimeout;
    private final TimeUnit ioShutdownUnit;
    private final int adminShutdownQuietPeriod;
    private final int adminShutdownTimeout;
    private final TimeUnit adminShutdownUnit;
    private final Timer timer;

    public DefaultNettyOptions(InternalDriverContext context) {
        this.config = context.getConfig().getDefaultProfile();
        boolean daemon = this.config.getBoolean(DefaultDriverOption.NETTY_DAEMON);
        int ioGroupSize = this.config.getInt(DefaultDriverOption.NETTY_IO_SIZE);
        this.ioShutdownQuietPeriod = this.config.getInt(DefaultDriverOption.NETTY_IO_SHUTDOWN_QUIET_PERIOD);
        this.ioShutdownTimeout = this.config.getInt(DefaultDriverOption.NETTY_IO_SHUTDOWN_TIMEOUT);
        this.ioShutdownUnit = TimeUnit.valueOf(this.config.getString(DefaultDriverOption.NETTY_IO_SHUTDOWN_UNIT));
        int adminGroupSize = this.config.getInt(DefaultDriverOption.NETTY_ADMIN_SIZE);
        this.adminShutdownQuietPeriod = this.config.getInt(DefaultDriverOption.NETTY_ADMIN_SHUTDOWN_QUIET_PERIOD);
        this.adminShutdownTimeout = this.config.getInt(DefaultDriverOption.NETTY_ADMIN_SHUTDOWN_TIMEOUT);
        this.adminShutdownUnit = TimeUnit.valueOf(this.config.getString(DefaultDriverOption.NETTY_ADMIN_SHUTDOWN_UNIT));
        BlockingOperation.SafeThreadFactory safeFactory = new BlockingOperation.SafeThreadFactory();
        ThreadFactory ioThreadFactory = new ThreadFactoryBuilder().setThreadFactory(safeFactory).setNameFormat(context.getSessionName() + "-io-%d").setDaemon(daemon).build();
        this.ioEventLoopGroup = new NioEventLoopGroup(ioGroupSize, ioThreadFactory);
        ThreadFactory adminThreadFactory = new ThreadFactoryBuilder().setThreadFactory(safeFactory).setNameFormat(context.getSessionName() + "-admin-%d").setDaemon(daemon).build();
        this.adminEventLoopGroup = new DefaultEventLoopGroup(adminGroupSize, adminThreadFactory);
        ThreadFactory timerThreadFactory = new ThreadFactoryBuilder().setThreadFactory(safeFactory).setNameFormat(context.getSessionName() + "-timer-%d").setDaemon(daemon).build();
        Duration tickDuration = this.config.getDuration(DefaultDriverOption.NETTY_TIMER_TICK_DURATION);
        if (PlatformDependent.isWindows() && tickDuration.toMillis() < 100L) {
            LOG.warn("Timer tick duration was set to a value too aggressive for Windows: {} ms; doing so is known to cause extreme CPU usage. Please set advanced.netty.timer.tick-duration to 100 ms or higher.", (Object)tickDuration.toMillis());
        }
        this.timer = this.createTimer(timerThreadFactory, tickDuration);
    }

    private HashedWheelTimer createTimer(ThreadFactory timerThreadFactory, Duration tickDuration) {
        HashedWheelTimer timer = new HashedWheelTimer(timerThreadFactory, tickDuration.toNanos(), TimeUnit.NANOSECONDS, this.config.getInt(DefaultDriverOption.NETTY_TIMER_TICKS_PER_WHEEL));
        timer.start();
        return timer;
    }

    @Override
    public EventLoopGroup ioEventLoopGroup() {
        return this.ioEventLoopGroup;
    }

    @Override
    public EventExecutorGroup adminEventExecutorGroup() {
        return this.adminEventLoopGroup;
    }

    @Override
    public Class<? extends Channel> channelClass() {
        return NioSocketChannel.class;
    }

    @Override
    public ByteBufAllocator allocator() {
        return ByteBufAllocator.DEFAULT;
    }

    @Override
    public void afterBootstrapInitialized(Bootstrap bootstrap) {
        boolean tcpNoDelay = this.config.getBoolean(DefaultDriverOption.SOCKET_TCP_NODELAY);
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)tcpNoDelay);
        if (this.config.isDefined(DefaultDriverOption.SOCKET_KEEP_ALIVE)) {
            boolean keepAlive = this.config.getBoolean(DefaultDriverOption.SOCKET_KEEP_ALIVE);
            bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)keepAlive);
        }
        if (this.config.isDefined(DefaultDriverOption.SOCKET_REUSE_ADDRESS)) {
            boolean reuseAddress = this.config.getBoolean(DefaultDriverOption.SOCKET_REUSE_ADDRESS);
            bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
        }
        if (this.config.isDefined(DefaultDriverOption.SOCKET_LINGER_INTERVAL)) {
            int lingerInterval = this.config.getInt(DefaultDriverOption.SOCKET_LINGER_INTERVAL);
            bootstrap.option(ChannelOption.SO_LINGER, (Object)lingerInterval);
        }
        if (this.config.isDefined(DefaultDriverOption.SOCKET_RECEIVE_BUFFER_SIZE)) {
            int receiveBufferSize = this.config.getInt(DefaultDriverOption.SOCKET_RECEIVE_BUFFER_SIZE);
            ((Bootstrap)bootstrap.option(ChannelOption.SO_RCVBUF, (Object)receiveBufferSize)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(receiveBufferSize));
        }
        if (this.config.isDefined(DefaultDriverOption.SOCKET_SEND_BUFFER_SIZE)) {
            int sendBufferSize = this.config.getInt(DefaultDriverOption.SOCKET_SEND_BUFFER_SIZE);
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)sendBufferSize);
        }
        if (this.config.isDefined(DefaultDriverOption.CONNECTION_CONNECT_TIMEOUT)) {
            Duration connectTimeout = this.config.getDuration(DefaultDriverOption.CONNECTION_CONNECT_TIMEOUT);
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Long.valueOf(connectTimeout.toMillis()).intValue());
        }
    }

    @Override
    public void afterChannelInitialized(Channel channel) {
    }

    @Override
    public Future<Void> onClose() {
        DefaultPromise closeFuture = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        GlobalEventExecutor.INSTANCE.execute(() -> PromiseCombiner.combine((Promise<Void>)closeFuture, this.adminEventLoopGroup.shutdownGracefully((long)this.adminShutdownQuietPeriod, (long)this.adminShutdownTimeout, this.adminShutdownUnit), this.ioEventLoopGroup.shutdownGracefully((long)this.ioShutdownQuietPeriod, (long)this.ioShutdownTimeout, this.ioShutdownUnit)));
        closeFuture.addListener(f -> this.timer.stop());
        return closeFuture;
    }

    @Override
    public synchronized Timer getTimer() {
        return this.timer;
    }
}

