/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.data;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.internal.core.util.Strings;
import com.datastax.oss.driver.shaded.guava.common.collect.LinkedListMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.ListMultimap;
import java.util.List;
import java.util.Locale;
import net.jcip.annotations.Immutable;

@Immutable
public class IdentifierIndex {
    private final ListMultimap<CqlIdentifier, Integer> byId;
    private final ListMultimap<String, Integer> byCaseSensitiveName;
    private final ListMultimap<String, Integer> byCaseInsensitiveName;

    public IdentifierIndex(List<CqlIdentifier> ids) {
        this.byId = LinkedListMultimap.create(ids.size());
        this.byCaseSensitiveName = LinkedListMultimap.create(ids.size());
        this.byCaseInsensitiveName = LinkedListMultimap.create(ids.size());
        int i = 0;
        for (CqlIdentifier id : ids) {
            this.byId.put(id, i);
            this.byCaseSensitiveName.put(id.asInternal(), i);
            this.byCaseInsensitiveName.put(id.asInternal().toLowerCase(Locale.ROOT), i);
            ++i;
        }
    }

    public List<Integer> allIndicesOf(String name) {
        return Strings.isDoubleQuoted(name) ? this.byCaseSensitiveName.get((Object)Strings.unDoubleQuote(name)) : this.byCaseInsensitiveName.get((Object)name.toLowerCase(Locale.ROOT));
    }

    public int firstIndexOf(String name) {
        List<Integer> indices = this.allIndicesOf(name);
        return indices.isEmpty() ? -1 : indices.get(0);
    }

    public List<Integer> allIndicesOf(CqlIdentifier id) {
        return this.byId.get((Object)id);
    }

    public int firstIndexOf(CqlIdentifier id) {
        List<Integer> indices = this.allIndicesOf(id);
        return indices.isEmpty() ? -1 : indices.get(0);
    }
}

