/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.codahale.metrics.MetricRegistry;
import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.api.core.metrics.DseNodeMetric;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.DropwizardMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.MetricId;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DropwizardNodeMetricUpdater
extends DropwizardMetricUpdater<NodeMetric>
implements NodeMetricUpdater {
    private final Node node;

    public DropwizardNodeMetricUpdater(Node node, InternalDriverContext context, Set<NodeMetric> enabledMetrics, MetricRegistry registry) {
        super(context, enabledMetrics, registry);
        this.node = node;
        DriverExecutionProfile profile = context.getConfig().getDefaultProfile();
        this.initializeGauge(DefaultNodeMetric.OPEN_CONNECTIONS, profile, node::getOpenConnections);
        this.initializeGauge(DefaultNodeMetric.AVAILABLE_STREAMS, profile, () -> this.availableStreamIds(node));
        this.initializeGauge(DefaultNodeMetric.IN_FLIGHT, profile, () -> this.inFlightRequests(node));
        this.initializeGauge(DefaultNodeMetric.ORPHANED_STREAMS, profile, () -> this.orphanedStreamIds(node));
        this.initializeCounter(DefaultNodeMetric.UNSENT_REQUESTS, profile);
        this.initializeCounter(DefaultNodeMetric.ABORTED_REQUESTS, profile);
        this.initializeCounter(DefaultNodeMetric.WRITE_TIMEOUTS, profile);
        this.initializeCounter(DefaultNodeMetric.READ_TIMEOUTS, profile);
        this.initializeCounter(DefaultNodeMetric.UNAVAILABLES, profile);
        this.initializeCounter(DefaultNodeMetric.OTHER_ERRORS, profile);
        this.initializeCounter(DefaultNodeMetric.RETRIES, profile);
        this.initializeCounter(DefaultNodeMetric.RETRIES_ON_ABORTED, profile);
        this.initializeCounter(DefaultNodeMetric.RETRIES_ON_READ_TIMEOUT, profile);
        this.initializeCounter(DefaultNodeMetric.RETRIES_ON_WRITE_TIMEOUT, profile);
        this.initializeCounter(DefaultNodeMetric.RETRIES_ON_UNAVAILABLE, profile);
        this.initializeCounter(DefaultNodeMetric.RETRIES_ON_OTHER_ERROR, profile);
        this.initializeCounter(DefaultNodeMetric.IGNORES, profile);
        this.initializeCounter(DefaultNodeMetric.IGNORES_ON_ABORTED, profile);
        this.initializeCounter(DefaultNodeMetric.IGNORES_ON_READ_TIMEOUT, profile);
        this.initializeCounter(DefaultNodeMetric.IGNORES_ON_WRITE_TIMEOUT, profile);
        this.initializeCounter(DefaultNodeMetric.IGNORES_ON_UNAVAILABLE, profile);
        this.initializeCounter(DefaultNodeMetric.IGNORES_ON_OTHER_ERROR, profile);
        this.initializeCounter(DefaultNodeMetric.SPECULATIVE_EXECUTIONS, profile);
        this.initializeCounter(DefaultNodeMetric.CONNECTION_INIT_ERRORS, profile);
        this.initializeCounter(DefaultNodeMetric.AUTHENTICATION_ERRORS, profile);
        this.initializeHdrTimer(DefaultNodeMetric.CQL_MESSAGES, profile, DefaultDriverOption.METRICS_NODE_CQL_MESSAGES_HIGHEST, DefaultDriverOption.METRICS_NODE_CQL_MESSAGES_DIGITS, DefaultDriverOption.METRICS_NODE_CQL_MESSAGES_INTERVAL);
        this.initializeHdrTimer(DseNodeMetric.GRAPH_MESSAGES, profile, (DriverOption)DseDriverOption.METRICS_NODE_GRAPH_MESSAGES_HIGHEST, (DriverOption)DseDriverOption.METRICS_NODE_GRAPH_MESSAGES_DIGITS, (DriverOption)DseDriverOption.METRICS_NODE_GRAPH_MESSAGES_INTERVAL);
    }

    @Override
    protected MetricId getMetricId(NodeMetric metric) {
        MetricId id = this.context.getMetricIdGenerator().nodeMetricId(this.node, metric);
        if (!id.getTags().isEmpty()) {
            throw new IllegalStateException("Cannot use metric tags with Dropwizard");
        }
        return id;
    }
}

