/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.codahale.metrics.MetricRegistry;
import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.api.core.metrics.DseSessionMetric;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.DropwizardMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.MetricId;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DropwizardSessionMetricUpdater
extends DropwizardMetricUpdater<SessionMetric>
implements SessionMetricUpdater {
    public DropwizardSessionMetricUpdater(InternalDriverContext context, Set<SessionMetric> enabledMetrics, MetricRegistry registry) {
        super(context, enabledMetrics, registry);
        DriverExecutionProfile profile = context.getConfig().getDefaultProfile();
        this.initializeGauge(DefaultSessionMetric.CONNECTED_NODES, profile, this::connectedNodes);
        this.initializeGauge(DefaultSessionMetric.THROTTLING_QUEUE_SIZE, profile, this::throttlingQueueSize);
        this.initializeGauge(DefaultSessionMetric.CQL_PREPARED_CACHE_SIZE, profile, this::preparedStatementCacheSize);
        this.initializeCounter(DefaultSessionMetric.CQL_CLIENT_TIMEOUTS, profile);
        this.initializeCounter(DefaultSessionMetric.THROTTLING_ERRORS, profile);
        this.initializeCounter(DseSessionMetric.GRAPH_CLIENT_TIMEOUTS, profile);
        this.initializeHdrTimer(DefaultSessionMetric.CQL_REQUESTS, profile, DefaultDriverOption.METRICS_SESSION_CQL_REQUESTS_HIGHEST, DefaultDriverOption.METRICS_SESSION_CQL_REQUESTS_DIGITS, DefaultDriverOption.METRICS_SESSION_CQL_REQUESTS_INTERVAL);
        this.initializeHdrTimer(DefaultSessionMetric.THROTTLING_DELAY, profile, DefaultDriverOption.METRICS_SESSION_THROTTLING_HIGHEST, DefaultDriverOption.METRICS_SESSION_THROTTLING_DIGITS, DefaultDriverOption.METRICS_SESSION_THROTTLING_INTERVAL);
        this.initializeHdrTimer(DseSessionMetric.CONTINUOUS_CQL_REQUESTS, profile, (DriverOption)DseDriverOption.CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_HIGHEST, (DriverOption)DseDriverOption.CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_DIGITS, (DriverOption)DseDriverOption.CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_INTERVAL);
        this.initializeHdrTimer(DseSessionMetric.GRAPH_REQUESTS, profile, (DriverOption)DseDriverOption.METRICS_SESSION_GRAPH_REQUESTS_HIGHEST, (DriverOption)DseDriverOption.METRICS_SESSION_GRAPH_REQUESTS_DIGITS, (DriverOption)DseDriverOption.METRICS_SESSION_GRAPH_REQUESTS_INTERVAL);
    }

    @Override
    protected MetricId getMetricId(SessionMetric metric) {
        MetricId id = this.context.getMetricIdGenerator().sessionMetricId(metric);
        if (!id.getTags().isEmpty()) {
            throw new IllegalStateException("Cannot use metric tags with Dropwizard");
        }
        return id;
    }
}

