/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.internal.core.type.DefaultTupleType;
import com.datastax.oss.driver.internal.core.type.DefaultUserDefinedType;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.protocol.internal.response.result.RawType;
import com.datastax.oss.protocol.internal.util.IntMap;
import java.util.List;
import java.util.Map;

public class DataTypeHelper {
    private static IntMap<DataType> PRIMITIVE_TYPES_BY_CODE = DataTypeHelper.sortByProtocolCode(DataTypes.ASCII, DataTypes.BIGINT, DataTypes.BLOB, DataTypes.BOOLEAN, DataTypes.COUNTER, DataTypes.DECIMAL, DataTypes.DOUBLE, DataTypes.FLOAT, DataTypes.INT, DataTypes.TIMESTAMP, DataTypes.UUID, DataTypes.VARINT, DataTypes.TIMEUUID, DataTypes.INET, DataTypes.DATE, DataTypes.TEXT, DataTypes.TIME, DataTypes.SMALLINT, DataTypes.TINYINT, DataTypes.DURATION);

    public static DataType fromProtocolSpec(RawType rawType, AttachmentPoint attachmentPoint) {
        DataType type = (DataType)PRIMITIVE_TYPES_BY_CODE.get(rawType.id);
        if (type != null) {
            return type;
        }
        switch (rawType.id) {
            case 0: {
                RawType.RawCustom rawCustom = (RawType.RawCustom)rawType;
                return DataTypes.custom(rawCustom.className);
            }
            case 32: {
                RawType.RawList rawList = (RawType.RawList)rawType;
                return DataTypes.listOf(DataTypeHelper.fromProtocolSpec(rawList.elementType, attachmentPoint));
            }
            case 34: {
                RawType.RawSet rawSet = (RawType.RawSet)rawType;
                return DataTypes.setOf(DataTypeHelper.fromProtocolSpec(rawSet.elementType, attachmentPoint));
            }
            case 33: {
                RawType.RawMap rawMap = (RawType.RawMap)rawType;
                return DataTypes.mapOf(DataTypeHelper.fromProtocolSpec(rawMap.keyType, attachmentPoint), DataTypeHelper.fromProtocolSpec(rawMap.valueType, attachmentPoint));
            }
            case 49: {
                RawType.RawTuple rawTuple = (RawType.RawTuple)rawType;
                List rawFieldsList = rawTuple.fieldTypes;
                ImmutableList.Builder fields = ImmutableList.builder();
                for (RawType rawField : rawFieldsList) {
                    fields.add(DataTypeHelper.fromProtocolSpec(rawField, attachmentPoint));
                }
                return new DefaultTupleType((List<DataType>)((Object)fields.build()), attachmentPoint);
            }
            case 48: {
                RawType.RawUdt rawUdt = (RawType.RawUdt)rawType;
                ImmutableList.Builder fieldNames = ImmutableList.builder();
                ImmutableList.Builder fieldTypes = ImmutableList.builder();
                for (Map.Entry entry : rawUdt.fields.entrySet()) {
                    fieldNames.add(CqlIdentifier.fromInternal((String)entry.getKey()));
                    fieldTypes.add(DataTypeHelper.fromProtocolSpec((RawType)entry.getValue(), attachmentPoint));
                }
                return new DefaultUserDefinedType(CqlIdentifier.fromInternal(rawUdt.keyspace), CqlIdentifier.fromInternal(rawUdt.typeName), false, (List<CqlIdentifier>)((Object)fieldNames.build()), (List<DataType>)((Object)fieldTypes.build()), attachmentPoint);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + rawType.id);
    }

    private static IntMap<DataType> sortByProtocolCode(DataType ... types) {
        IntMap.Builder builder = IntMap.builder();
        for (DataType type : types) {
            builder.put(type.getProtocolCode(), (Object)type);
        }
        return builder.build();
    }
}

