/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db;

import io.stargate.db.ComparableKey;
import io.stargate.db.RowDecorator;
import io.stargate.db.datastore.Row;
import io.stargate.db.schema.TableName;
import java.nio.ByteBuffer;
import java.util.List;

public abstract class AbstractRowDecorator
implements RowDecorator {
    private final TableName table;
    private final List<String> partitionKeyColumnNames;

    protected AbstractRowDecorator(TableName table, List<String> partitionKeyColumnNames) {
        this.table = table;
        this.partitionKeyColumnNames = partitionKeyColumnNames;
    }

    protected abstract ComparableKey<?> decoratePrimaryKey(Object ... var1);

    protected Object[] primaryKeyValues(Row row) {
        Object[] pkValues = new Object[this.partitionKeyColumnNames.size()];
        int idx = 0;
        for (String columnName : this.partitionKeyColumnNames) {
            ByteBuffer value = row.getBytesUnsafe(columnName);
            if (value == null) {
                throw new IllegalArgumentException(String.format("Required value is not present in current row (table: %s, column: %s)", this.table.name(), columnName));
            }
            pkValues[idx++] = value;
        }
        return pkValues;
    }

    @Override
    public <T extends Comparable<T>> ComparableKey<T> decoratePartitionKey(Row row) {
        Object[] pkValues = this.primaryKeyValues(row);
        return this.decoratePrimaryKey(pkValues);
    }
}

