/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db;

import io.stargate.db.AuthenticatedUser;
import io.stargate.db.DriverInfo;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public class ClientInfo {
    public static final String PROXY_SOURCE_ADDRESS_HEADER = "proxy_source_address_header";
    public static final String PROXY_PUBLIC_ADDRESS_HEADER = "proxy_public_address_header";
    private final InetSocketAddress remoteAddress;
    private final int boundPort;
    @Nullable
    private final InetSocketAddress destinationAddress;
    private volatile DriverInfo driverInfo;
    private AuthenticatedUser authenticatedUser;
    private Map<String, ByteBuffer> serializedAuthData;

    public ClientInfo(InetSocketAddress remoteAddress, int boundPort, @Nullable InetSocketAddress destinationAddress) {
        this.remoteAddress = remoteAddress;
        this.boundPort = boundPort;
        this.destinationAddress = destinationAddress;
    }

    public ClientInfo(InetSocketAddress remoteAddress, @Nullable InetSocketAddress destinationAddress) {
        this.remoteAddress = remoteAddress;
        this.boundPort = 0;
        this.destinationAddress = destinationAddress;
    }

    public InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public int boundPort() {
        return this.boundPort;
    }

    public Optional<InetSocketAddress> destinationAddress() {
        return Optional.ofNullable(this.destinationAddress);
    }

    public void registerDriverInfo(DriverInfo info) {
        if (this.driverInfo != null) {
            throw new IllegalStateException(String.format("Driver info has already been set (to %s)", this.driverInfo));
        }
        this.driverInfo = info;
    }

    public Optional<DriverInfo> driverInfo() {
        return Optional.ofNullable(this.driverInfo);
    }

    public AuthenticatedUser getAuthenticatedUser() {
        return this.authenticatedUser;
    }

    public void setAuthenticatedUser(AuthenticatedUser authenticatedUser) {
        this.authenticatedUser = authenticatedUser;
        this.serializedAuthData = AuthenticatedUser.Serializer.serialize(authenticatedUser);
    }

    public void storeAuthenticationData(Map<String, ByteBuffer> payload) {
        if (this.serializedAuthData != null) {
            for (Map.Entry<String, ByteBuffer> e : this.serializedAuthData.entrySet()) {
                payload.put(e.getKey(), e.getValue().duplicate());
            }
        }
    }

    public String toString() {
        return "ClientInfo{remoteAddress=" + this.remoteAddress + ", destinationAddress=" + this.destinationAddress + ", driverInfo=" + this.driverInfo + '}';
    }
}

