/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db;

import java.util.Objects;

public final class ComparableKey<T extends Comparable<? super T>>
implements Comparable<ComparableKey<?>> {
    private final Class<T> delegateClass;
    private final T delegate;

    public ComparableKey(Class<T> delegateClass, T delegate) {
        this.delegateClass = delegateClass;
        this.delegate = delegate;
    }

    @Override
    public int compareTo(ComparableKey<?> o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.delegateClass != o.delegateClass) {
            int cmp = this.delegateClass.getName().compareTo(o.delegateClass.getName());
            if (cmp != 0) {
                return cmp;
            }
            throw new IllegalStateException("Mixing different delegate classes with the same name: " + this.delegateClass.getName());
        }
        T other = o.delegate;
        return this.delegate.compareTo(other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparableKey that = (ComparableKey)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return "ComparableKey{" + this.delegate + '}';
    }
}

