/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db;

import io.stargate.core.activator.BaseActivator;
import io.stargate.db.Persistence;
import io.stargate.db.RateLimitingPersistence;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.datastore.PersistenceDataStoreFactory;
import io.stargate.db.limiter.RateLimitingManager;
import io.stargate.db.metrics.api.ClientInfoMetricsTagProvider;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class DbActivator
extends BaseActivator {
    public static final String PERSISTENCE_IDENTIFIER = "StargatePersistence";
    public static final String RATE_LIMITING_ID_PROPERTY = "stargate.limiter.id";
    private static final String DB_PERSISTENCE_IDENTIFIER = System.getProperty("stargate.persistence_id", "CassandraPersistence");
    private static final String RATE_LIMITING_IDENTIFIER = System.getProperty("stargate.limiter.id", "<none>");
    private static final String CLIENT_INFO_TAG_PROVIDER_ID = System.getProperty("stargate.metrics.client_info_tag_provider.id");
    private final BaseActivator.ServicePointer<Persistence> dbPersistence = BaseActivator.ServicePointer.create(Persistence.class, (String)"Identifier", (String)DB_PERSISTENCE_IDENTIFIER);
    private final BaseActivator.ServicePointer<RateLimitingManager> rateLimitingManager = BaseActivator.ServicePointer.create(RateLimitingManager.class, (String)"Identifier", (String)RATE_LIMITING_IDENTIFIER);

    public DbActivator() {
        super("DB services");
    }

    private boolean hasRateLimitingEnabled() {
        return !RATE_LIMITING_IDENTIFIER.equalsIgnoreCase("<none>");
    }

    protected List<BaseActivator.ServiceAndProperties> createServices() {
        Persistence persistence = (Persistence)this.dbPersistence.get();
        if (this.hasRateLimitingEnabled()) {
            RateLimitingManager rateLimiter = (RateLimitingManager)this.rateLimitingManager.get();
            if (rateLimiter == null) {
                throw new RuntimeException(String.format("Could not find rate limiter service with id '%s'", RATE_LIMITING_IDENTIFIER));
            }
            persistence = new RateLimitingPersistence(persistence, rateLimiter);
        }
        ArrayList<BaseActivator.ServiceAndProperties> services = new ArrayList<BaseActivator.ServiceAndProperties>();
        services.add(new BaseActivator.ServiceAndProperties((Object)persistence, Persistence.class, DbActivator.stargatePersistenceProperties()));
        services.add(new BaseActivator.ServiceAndProperties((Object)new PersistenceDataStoreFactory(persistence), DataStoreFactory.class));
        if (null == CLIENT_INFO_TAG_PROVIDER_ID) {
            services.add(new BaseActivator.ServiceAndProperties((Object)ClientInfoMetricsTagProvider.DEFAULT, ClientInfoMetricsTagProvider.class));
        }
        return services;
    }

    private static Hashtable<String, String> stargatePersistenceProperties() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("Identifier", PERSISTENCE_IDENTIFIER);
        return props;
    }

    protected List<BaseActivator.ServicePointer<?>> dependencies() {
        ArrayList deps = new ArrayList(2);
        deps.add(this.dbPersistence);
        if (this.hasRateLimitingEnabled()) {
            deps.add(this.rateLimitingManager);
        }
        return deps;
    }
}

