/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.DriverInfo;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="DriverInfo", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableDriverInfo
implements DriverInfo {
    private final String name;
    @Nullable
    private final String version;

    private ImmutableDriverInfo(String name, @Nullable String version) {
        this.name = name;
        this.version = version;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Optional<String> version() {
        return Optional.ofNullable(this.version);
    }

    public final ImmutableDriverInfo withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableDriverInfo(newValue, this.version);
    }

    public final ImmutableDriverInfo withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (Objects.equals(this.version, newValue)) {
            return this;
        }
        return new ImmutableDriverInfo(this.name, newValue);
    }

    public final ImmutableDriverInfo withVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return new ImmutableDriverInfo(this.name, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDriverInfo && this.equalTo((ImmutableDriverInfo)another);
    }

    private boolean equalTo(ImmutableDriverInfo another) {
        return this.name.equals(another.name) && Objects.equals(this.version, another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.version);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DriverInfo{");
        builder.append("name=").append(this.name);
        if (this.version != null) {
            builder.append(", ");
            builder.append("version=").append(this.version);
        }
        return builder.append("}").toString();
    }

    public static ImmutableDriverInfo copyOf(DriverInfo instance) {
        if (instance instanceof ImmutableDriverInfo) {
            return (ImmutableDriverInfo)instance;
        }
        return ImmutableDriverInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DriverInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        @Nullable
        private String version;

        private Builder() {
        }

        public final Builder from(DriverInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            Optional<String> versionOptional = instance.version();
            if (versionOptional.isPresent()) {
                this.version(versionOptional);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        public final Builder version(Optional<String> version) {
            this.version = version.orElse(null);
            return this;
        }

        public ImmutableDriverInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDriverInfo(this.name, this.version);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build DriverInfo, some of required attributes are not set " + attributes;
        }
    }
}

