/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.Parameters;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.stargate.db.ConsistencyLevel;
import org.apache.cassandra.stargate.transport.ProtocolVersion;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Parameters", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableParameters
extends Parameters {
    private final ProtocolVersion protocolVersion;
    @Nullable
    private final Integer pageSize;
    @Nullable
    private final ByteBuffer pagingState;
    private final ConsistencyLevel consistencyLevel;
    @Nullable
    private final ConsistencyLevel serialConsistencyLevel;
    @Nullable
    private final Long defaultTimestamp;
    @Nullable
    private final Integer nowInSeconds;
    @Nullable
    private final String defaultKeyspace;
    @Nullable
    private final Map<String, ByteBuffer> customPayload;
    private final boolean skipMetadataInResult;
    private final boolean tracingRequested;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableParameters INSTANCE = ImmutableParameters.validate(new ImmutableParameters());

    private ImmutableParameters() {
        this.pageSize = null;
        this.pagingState = null;
        this.serialConsistencyLevel = null;
        this.defaultTimestamp = null;
        this.nowInSeconds = null;
        this.defaultKeyspace = null;
        this.customPayload = null;
        this.protocolVersion = this.initShim.protocolVersion();
        this.consistencyLevel = this.initShim.consistencyLevel();
        this.skipMetadataInResult = this.initShim.skipMetadataInResult();
        this.tracingRequested = this.initShim.tracingRequested();
        this.initShim = null;
    }

    private ImmutableParameters(Builder builder) {
        this.pageSize = builder.pageSize;
        this.pagingState = builder.pagingState;
        this.serialConsistencyLevel = builder.serialConsistencyLevel;
        this.defaultTimestamp = builder.defaultTimestamp;
        this.nowInSeconds = builder.nowInSeconds;
        this.defaultKeyspace = builder.defaultKeyspace;
        this.customPayload = builder.customPayload;
        if (builder.protocolVersion != null) {
            this.initShim.protocolVersion(builder.protocolVersion);
        }
        if (builder.consistencyLevel != null) {
            this.initShim.consistencyLevel(builder.consistencyLevel);
        }
        if (builder.skipMetadataInResultIsSet()) {
            this.initShim.skipMetadataInResult(builder.skipMetadataInResult);
        }
        if (builder.tracingRequestedIsSet()) {
            this.initShim.tracingRequested(builder.tracingRequested);
        }
        this.protocolVersion = this.initShim.protocolVersion();
        this.consistencyLevel = this.initShim.consistencyLevel();
        this.skipMetadataInResult = this.initShim.skipMetadataInResult();
        this.tracingRequested = this.initShim.tracingRequested();
        this.initShim = null;
    }

    private ImmutableParameters(ProtocolVersion protocolVersion, @Nullable Integer pageSize, @Nullable ByteBuffer pagingState, ConsistencyLevel consistencyLevel, @Nullable ConsistencyLevel serialConsistencyLevel, @Nullable Long defaultTimestamp, @Nullable Integer nowInSeconds, @Nullable String defaultKeyspace, @Nullable Map<String, ByteBuffer> customPayload, boolean skipMetadataInResult, boolean tracingRequested) {
        this.protocolVersion = protocolVersion;
        this.pageSize = pageSize;
        this.pagingState = pagingState;
        this.consistencyLevel = consistencyLevel;
        this.serialConsistencyLevel = serialConsistencyLevel;
        this.defaultTimestamp = defaultTimestamp;
        this.nowInSeconds = nowInSeconds;
        this.defaultKeyspace = defaultKeyspace;
        this.customPayload = customPayload;
        this.skipMetadataInResult = skipMetadataInResult;
        this.tracingRequested = tracingRequested;
        this.initShim = null;
    }

    @Override
    public ProtocolVersion protocolVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.protocolVersion() : this.protocolVersion;
    }

    @Override
    public OptionalInt pageSize() {
        return this.pageSize != null ? OptionalInt.of(this.pageSize) : OptionalInt.empty();
    }

    @Override
    public Optional<ByteBuffer> pagingState() {
        return Optional.ofNullable(this.pagingState);
    }

    @Override
    public ConsistencyLevel consistencyLevel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.consistencyLevel() : this.consistencyLevel;
    }

    @Override
    public Optional<ConsistencyLevel> serialConsistencyLevel() {
        return Optional.ofNullable(this.serialConsistencyLevel);
    }

    @Override
    public OptionalLong defaultTimestamp() {
        return this.defaultTimestamp != null ? OptionalLong.of(this.defaultTimestamp) : OptionalLong.empty();
    }

    @Override
    public OptionalInt nowInSeconds() {
        return this.nowInSeconds != null ? OptionalInt.of(this.nowInSeconds) : OptionalInt.empty();
    }

    @Override
    public Optional<String> defaultKeyspace() {
        return Optional.ofNullable(this.defaultKeyspace);
    }

    @Override
    public Optional<Map<String, ByteBuffer>> customPayload() {
        return Optional.ofNullable(this.customPayload);
    }

    @Override
    public boolean skipMetadataInResult() {
        InitShim shim = this.initShim;
        return shim != null ? shim.skipMetadataInResult() : this.skipMetadataInResult;
    }

    @Override
    public boolean tracingRequested() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tracingRequested() : this.tracingRequested;
    }

    public final ImmutableParameters withProtocolVersion(ProtocolVersion value) {
        if (this.protocolVersion == value) {
            return this;
        }
        ProtocolVersion newValue = Objects.requireNonNull(value, "protocolVersion");
        if (this.protocolVersion.equals(newValue)) {
            return this;
        }
        return ImmutableParameters.validate(new ImmutableParameters(newValue, this.pageSize, this.pagingState, this.consistencyLevel, this.serialConsistencyLevel, this.defaultTimestamp, this.nowInSeconds, this.defaultKeyspace, this.customPayload, this.skipMetadataInResult, this.tracingRequested));
    }

    public final ImmutableParameters withPageSize(int value) {
        Integer newValue = value;
        if (Objects.equals(this.pageSize, newValue)) {
            return this;
        }
        return ImmutableParameters.validate(new ImmutableParameters(this.protocolVersion, newValue, this.pagingState, this.consistencyLevel, this.serialConsistencyLevel, this.defaultTimestamp, this.nowInSeconds, this.defaultKeyspace, this.customPayload, this.skipMetadataInResult, this.tracingRequested));
    }

    public final ImmutableParameters withPageSize(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.pageSize, value)) {
            return this;
        }
        return ImmutableParameters.validate(new ImmutableParameters(this.protocolVersion, value, this.pagingState, this.consistencyLevel, this.serialConsistencyLevel, this.defaultTimestamp, this.nowInSeconds, this.defaultKeyspace, this.customPayload, this.skipMetadataInResult, this.tracingRequested));
    }

    @Override
    public final ImmutableParameters withPagingState(ByteBuffer value) {
        ByteBuffer newValue = Objects.requireNonNull(value, "pagingState");
        if (this.pagingState == newValue) {
            return this;
        }
        return ImmutableParameters.validate(new ImmutableParameters(this.protocolVersion, this.pageSize, newValue, this.consistencyLevel, this.serialConsistencyLevel, this.defaultTimestamp, this.nowInSeconds, this.defaultKeyspace, this.customPayload, this.skipMetadataInResult, this.tracingRequested));
    }

    public final ImmutableParameters withPagingState(Optional<? extends ByteBuffer> optional) {
        ByteBuffer value = optional.orElse(null);
        if (this.pagingState == value) {
            return this;
        }
        return ImmutableParameters.validate(new ImmutableParameters(this.protocolVersion, this.pageSize, value, this.consistencyLevel, this.serialConsistencyLevel, this.defaultTimestamp, this.nowInSeconds, this.defaultKeyspace, this.customPayload, this.skipMetadataInResult, this.tracingRequested));
    }

    @Override
    public final ImmutableParameters withConsistencyLevel(ConsistencyLevel value) {
        if (this.consistencyLevel == value) {
            return this;
        }
        ConsistencyLevel newValue = Objects.requireNonNull(value, "consistencyLevel");
        if (this.consistencyLevel.equals((Object)newValue)) {
            return this;
        }
        return ImmutableParameters.validate(new ImmutableParameters(this.protocolVersion, this.pageSize, this.pagingState, newValue, this.serialConsistencyLevel, this.defaultTimestamp, this.nowInSeconds, this.defaultKeyspace, this.customPayload, this.skipMetadataInResult, this.tracingRequested));
    }

    public final ImmutableParameters withSerialConsistencyLevel(ConsistencyLevel value) {
        ConsistencyLevel newValue = Objects.requireNonNull(value, "serialConsistencyLevel");
        if (this.serialConsistencyLevel == newValue) {
            return this;
        }
        return ImmutableParameters.validate(new ImmutableParameters(this.protocolVersion, this.pageSize, this.pagingState, this.consistencyLevel, newValue, this.defaultTimestamp, this.nowInSeconds, this.defaultKeyspace, this.customPayload, this.skipMetadataInResult, this.tracingRequested));
    }

    public final ImmutableParameters withSerialConsistencyLevel(Optional<? extends ConsistencyLevel> optional) {
        ConsistencyLevel value = optional.orElse(null);
        if (Objects.equals((Object)this.serialConsistencyLevel, (Object)value)) {
            return this;
        }
        return ImmutableParameters.validate(new ImmutableParameters(this.protocolVersion, this.pageSize, this.pagingState, this.consistencyLevel, value, this.defaultTimestamp, this.nowInSeconds, this.defaultKeyspace, this.customPayload, this.skipMetadataInResult, this.tracingRequested));
    }

    public final ImmutableParameters withDefaultTimestamp(long value) {
        Long newValue = value;
        if (Objects.equals(this.defaultTimestamp, newValue)) {
            return this;
        }
        return ImmutableParameters.validate(new ImmutableParameters(this.protocolVersion, this.pageSize, this.pagingState, this.consistencyLevel, this.serialConsistencyLevel, newValue, this.nowInSeconds, this.defaultKeyspace, this.customPayload, this.skipMetadataInResult, this.tracingRequested));
    }

    public final ImmutableParameters withDefaultTimestamp(OptionalLong optional) {
        Long value;
        Long l = value = optional.isPresent() ? Long.valueOf(optional.getAsLong()) : null;
        if (Objects.equals(this.defaultTimestamp, value)) {
            return this;
        }
        return ImmutableParameters.validate(new ImmutableParameters(this.protocolVersion, this.pageSize, this.pagingState, this.consistencyLevel, this.serialConsistencyLevel, value, this.nowInSeconds, this.defaultKeyspace, this.customPayload, this.skipMetadataInResult, this.tracingRequested));
    }

    public final ImmutableParameters withNowInSeconds(int value) {
        Integer newValue = value;
        if (Objects.equals(this.nowInSeconds, newValue)) {
            return this;
        }
        return ImmutableParameters.validate(new ImmutableParameters(this.protocolVersion, this.pageSize, this.pagingState, this.consistencyLevel, this.serialConsistencyLevel, this.defaultTimestamp, newValue, this.defaultKeyspace, this.customPayload, this.skipMetadataInResult, this.tracingRequested));
    }

    public final ImmutableParameters withNowInSeconds(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.nowInSeconds, value)) {
            return this;
        }
        return ImmutableParameters.validate(new ImmutableParameters(this.protocolVersion, this.pageSize, this.pagingState, this.consistencyLevel, this.serialConsistencyLevel, this.defaultTimestamp, value, this.defaultKeyspace, this.customPayload, this.skipMetadataInResult, this.tracingRequested));
    }

    public final ImmutableParameters withDefaultKeyspace(String value) {
        String newValue = Objects.requireNonNull(value, "defaultKeyspace");
        if (Objects.equals(this.defaultKeyspace, newValue)) {
            return this;
        }
        return ImmutableParameters.validate(new ImmutableParameters(this.protocolVersion, this.pageSize, this.pagingState, this.consistencyLevel, this.serialConsistencyLevel, this.defaultTimestamp, this.nowInSeconds, newValue, this.customPayload, this.skipMetadataInResult, this.tracingRequested));
    }

    public final ImmutableParameters withDefaultKeyspace(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.defaultKeyspace, value)) {
            return this;
        }
        return ImmutableParameters.validate(new ImmutableParameters(this.protocolVersion, this.pageSize, this.pagingState, this.consistencyLevel, this.serialConsistencyLevel, this.defaultTimestamp, this.nowInSeconds, value, this.customPayload, this.skipMetadataInResult, this.tracingRequested));
    }

    public final ImmutableParameters withCustomPayload(Map<String, ByteBuffer> value) {
        Map<String, ByteBuffer> newValue = Objects.requireNonNull(value, "customPayload");
        if (this.customPayload == newValue) {
            return this;
        }
        return ImmutableParameters.validate(new ImmutableParameters(this.protocolVersion, this.pageSize, this.pagingState, this.consistencyLevel, this.serialConsistencyLevel, this.defaultTimestamp, this.nowInSeconds, this.defaultKeyspace, newValue, this.skipMetadataInResult, this.tracingRequested));
    }

    public final ImmutableParameters withCustomPayload(Optional<? extends Map<String, ByteBuffer>> optional) {
        Map value = optional.orElse(null);
        if (this.customPayload == value) {
            return this;
        }
        return ImmutableParameters.validate(new ImmutableParameters(this.protocolVersion, this.pageSize, this.pagingState, this.consistencyLevel, this.serialConsistencyLevel, this.defaultTimestamp, this.nowInSeconds, this.defaultKeyspace, value, this.skipMetadataInResult, this.tracingRequested));
    }

    public final ImmutableParameters withSkipMetadataInResult(boolean value) {
        if (this.skipMetadataInResult == value) {
            return this;
        }
        return ImmutableParameters.validate(new ImmutableParameters(this.protocolVersion, this.pageSize, this.pagingState, this.consistencyLevel, this.serialConsistencyLevel, this.defaultTimestamp, this.nowInSeconds, this.defaultKeyspace, this.customPayload, value, this.tracingRequested));
    }

    public final ImmutableParameters withTracingRequested(boolean value) {
        if (this.tracingRequested == value) {
            return this;
        }
        return ImmutableParameters.validate(new ImmutableParameters(this.protocolVersion, this.pageSize, this.pagingState, this.consistencyLevel, this.serialConsistencyLevel, this.defaultTimestamp, this.nowInSeconds, this.defaultKeyspace, this.customPayload, this.skipMetadataInResult, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableParameters && this.equalTo((ImmutableParameters)another);
    }

    private boolean equalTo(ImmutableParameters another) {
        return this.protocolVersion.equals(another.protocolVersion) && Objects.equals(this.pageSize, another.pageSize) && Objects.equals(this.pagingState, another.pagingState) && this.consistencyLevel.equals((Object)another.consistencyLevel) && Objects.equals((Object)this.serialConsistencyLevel, (Object)another.serialConsistencyLevel) && Objects.equals(this.defaultTimestamp, another.defaultTimestamp) && Objects.equals(this.nowInSeconds, another.nowInSeconds) && Objects.equals(this.defaultKeyspace, another.defaultKeyspace) && Objects.equals(this.customPayload, another.customPayload) && this.skipMetadataInResult == another.skipMetadataInResult && this.tracingRequested == another.tracingRequested;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.protocolVersion.hashCode();
        h += (h << 5) + Objects.hashCode(this.pageSize);
        h += (h << 5) + Objects.hashCode(this.pagingState);
        h += (h << 5) + this.consistencyLevel.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.serialConsistencyLevel);
        h += (h << 5) + Objects.hashCode(this.defaultTimestamp);
        h += (h << 5) + Objects.hashCode(this.nowInSeconds);
        h += (h << 5) + Objects.hashCode(this.defaultKeyspace);
        h += (h << 5) + Objects.hashCode(this.customPayload);
        h += (h << 5) + Boolean.hashCode(this.skipMetadataInResult);
        h += (h << 5) + Boolean.hashCode(this.tracingRequested);
        return h;
    }

    public static ImmutableParameters of() {
        return INSTANCE;
    }

    private static ImmutableParameters validate(ImmutableParameters instance) {
        instance.validate();
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static ImmutableParameters copyOf(Parameters instance) {
        if (instance instanceof ImmutableParameters) {
            return (ImmutableParameters)instance;
        }
        return ImmutableParameters.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Parameters", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SKIP_METADATA_IN_RESULT = 1L;
        private static final long OPT_BIT_TRACING_REQUESTED = 2L;
        private long optBits;
        @Nullable
        private ProtocolVersion protocolVersion;
        @Nullable
        private Integer pageSize;
        @Nullable
        private ByteBuffer pagingState;
        @Nullable
        private ConsistencyLevel consistencyLevel;
        @Nullable
        private ConsistencyLevel serialConsistencyLevel;
        @Nullable
        private Long defaultTimestamp;
        @Nullable
        private Integer nowInSeconds;
        @Nullable
        private String defaultKeyspace;
        @Nullable
        private Map<String, ByteBuffer> customPayload;
        private boolean skipMetadataInResult;
        private boolean tracingRequested;

        private Builder() {
        }

        public final Builder from(Parameters instance) {
            Optional<Map<String, ByteBuffer>> customPayloadOptional;
            Optional<String> defaultKeyspaceOptional;
            OptionalInt nowInSecondsOptional;
            OptionalLong defaultTimestampOptional;
            Optional<ByteBuffer> pagingStateOptional;
            Objects.requireNonNull(instance, "instance");
            this.protocolVersion(instance.protocolVersion());
            OptionalInt pageSizeOptional = instance.pageSize();
            if (pageSizeOptional.isPresent()) {
                this.pageSize(pageSizeOptional);
            }
            if ((pagingStateOptional = instance.pagingState()).isPresent()) {
                this.pagingState(pagingStateOptional);
            }
            this.consistencyLevel(instance.consistencyLevel());
            Optional<ConsistencyLevel> serialConsistencyLevelOptional = instance.serialConsistencyLevel();
            if (serialConsistencyLevelOptional.isPresent()) {
                this.serialConsistencyLevel(serialConsistencyLevelOptional);
            }
            if ((defaultTimestampOptional = instance.defaultTimestamp()).isPresent()) {
                this.defaultTimestamp(defaultTimestampOptional);
            }
            if ((nowInSecondsOptional = instance.nowInSeconds()).isPresent()) {
                this.nowInSeconds(nowInSecondsOptional);
            }
            if ((defaultKeyspaceOptional = instance.defaultKeyspace()).isPresent()) {
                this.defaultKeyspace(defaultKeyspaceOptional);
            }
            if ((customPayloadOptional = instance.customPayload()).isPresent()) {
                this.customPayload(customPayloadOptional);
            }
            this.skipMetadataInResult(instance.skipMetadataInResult());
            this.tracingRequested(instance.tracingRequested());
            return this;
        }

        public final Builder protocolVersion(ProtocolVersion protocolVersion) {
            this.protocolVersion = Objects.requireNonNull(protocolVersion, "protocolVersion");
            return this;
        }

        public final Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final Builder pageSize(OptionalInt pageSize) {
            this.pageSize = pageSize.isPresent() ? Integer.valueOf(pageSize.getAsInt()) : null;
            return this;
        }

        public final Builder pagingState(ByteBuffer pagingState) {
            this.pagingState = Objects.requireNonNull(pagingState, "pagingState");
            return this;
        }

        public final Builder pagingState(Optional<? extends ByteBuffer> pagingState) {
            this.pagingState = pagingState.orElse(null);
            return this;
        }

        public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel = Objects.requireNonNull(consistencyLevel, "consistencyLevel");
            return this;
        }

        public final Builder serialConsistencyLevel(ConsistencyLevel serialConsistencyLevel) {
            this.serialConsistencyLevel = Objects.requireNonNull(serialConsistencyLevel, "serialConsistencyLevel");
            return this;
        }

        public final Builder serialConsistencyLevel(Optional<? extends ConsistencyLevel> serialConsistencyLevel) {
            this.serialConsistencyLevel = serialConsistencyLevel.orElse(null);
            return this;
        }

        public final Builder defaultTimestamp(long defaultTimestamp) {
            this.defaultTimestamp = defaultTimestamp;
            return this;
        }

        public final Builder defaultTimestamp(OptionalLong defaultTimestamp) {
            this.defaultTimestamp = defaultTimestamp.isPresent() ? Long.valueOf(defaultTimestamp.getAsLong()) : null;
            return this;
        }

        public final Builder nowInSeconds(int nowInSeconds) {
            this.nowInSeconds = nowInSeconds;
            return this;
        }

        public final Builder nowInSeconds(OptionalInt nowInSeconds) {
            this.nowInSeconds = nowInSeconds.isPresent() ? Integer.valueOf(nowInSeconds.getAsInt()) : null;
            return this;
        }

        public final Builder defaultKeyspace(String defaultKeyspace) {
            this.defaultKeyspace = Objects.requireNonNull(defaultKeyspace, "defaultKeyspace");
            return this;
        }

        public final Builder defaultKeyspace(Optional<String> defaultKeyspace) {
            this.defaultKeyspace = defaultKeyspace.orElse(null);
            return this;
        }

        public final Builder customPayload(Map<String, ByteBuffer> customPayload) {
            this.customPayload = Objects.requireNonNull(customPayload, "customPayload");
            return this;
        }

        public final Builder customPayload(Optional<? extends Map<String, ByteBuffer>> customPayload) {
            this.customPayload = customPayload.orElse(null);
            return this;
        }

        public final Builder skipMetadataInResult(boolean skipMetadataInResult) {
            this.skipMetadataInResult = skipMetadataInResult;
            this.optBits |= 1L;
            return this;
        }

        public final Builder tracingRequested(boolean tracingRequested) {
            this.tracingRequested = tracingRequested;
            this.optBits |= 2L;
            return this;
        }

        public ImmutableParameters build() {
            return ImmutableParameters.validate(new ImmutableParameters(this));
        }

        private boolean skipMetadataInResultIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean tracingRequestedIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Generated(from="Parameters", generator="Immutables")
    private final class InitShim {
        private byte protocolVersionBuildStage = 0;
        private ProtocolVersion protocolVersion;
        private byte consistencyLevelBuildStage = 0;
        private ConsistencyLevel consistencyLevel;
        private byte skipMetadataInResultBuildStage = 0;
        private boolean skipMetadataInResult;
        private byte tracingRequestedBuildStage = 0;
        private boolean tracingRequested;

        private InitShim() {
        }

        ProtocolVersion protocolVersion() {
            if (this.protocolVersionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.protocolVersionBuildStage == 0) {
                this.protocolVersionBuildStage = (byte)-1;
                this.protocolVersion = Objects.requireNonNull(ImmutableParameters.super.protocolVersion(), "protocolVersion");
                this.protocolVersionBuildStage = 1;
            }
            return this.protocolVersion;
        }

        void protocolVersion(ProtocolVersion protocolVersion) {
            this.protocolVersion = protocolVersion;
            this.protocolVersionBuildStage = 1;
        }

        ConsistencyLevel consistencyLevel() {
            if (this.consistencyLevelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.consistencyLevelBuildStage == 0) {
                this.consistencyLevelBuildStage = (byte)-1;
                this.consistencyLevel = Objects.requireNonNull(ImmutableParameters.super.consistencyLevel(), "consistencyLevel");
                this.consistencyLevelBuildStage = 1;
            }
            return this.consistencyLevel;
        }

        void consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            this.consistencyLevelBuildStage = 1;
        }

        boolean skipMetadataInResult() {
            if (this.skipMetadataInResultBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.skipMetadataInResultBuildStage == 0) {
                this.skipMetadataInResultBuildStage = (byte)-1;
                this.skipMetadataInResult = ImmutableParameters.super.skipMetadataInResult();
                this.skipMetadataInResultBuildStage = 1;
            }
            return this.skipMetadataInResult;
        }

        void skipMetadataInResult(boolean skipMetadataInResult) {
            this.skipMetadataInResult = skipMetadataInResult;
            this.skipMetadataInResultBuildStage = 1;
        }

        boolean tracingRequested() {
            if (this.tracingRequestedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tracingRequestedBuildStage == 0) {
                this.tracingRequestedBuildStage = (byte)-1;
                this.tracingRequested = ImmutableParameters.super.tracingRequested();
                this.tracingRequestedBuildStage = 1;
            }
            return this.tracingRequested;
        }

        void tracingRequested(boolean tracingRequested) {
            this.tracingRequested = tracingRequested;
            this.tracingRequestedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.protocolVersionBuildStage == -1) {
                attributes.add("protocolVersion");
            }
            if (this.consistencyLevelBuildStage == -1) {
                attributes.add("consistencyLevel");
            }
            if (this.skipMetadataInResultBuildStage == -1) {
                attributes.add("skipMetadataInResult");
            }
            if (this.tracingRequestedBuildStage == -1) {
                attributes.add("tracingRequested");
            }
            return "Cannot build Parameters, attribute initializers form cycle " + attributes;
        }
    }
}

