/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db;

import io.stargate.db.ImmutableParameters;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.Nonnull;
import org.apache.cassandra.stargate.db.ConsistencyLevel;
import org.apache.cassandra.stargate.transport.ProtocolVersion;
import org.immutables.value.Value;

@Value.Immutable(singleton=true)
public abstract class Parameters {
    private static final ConsistencyLevel DEFAULT_CONSISTENCY = ConsistencyLevel.ONE;
    private static final ProtocolVersion DEFAULT_PROTOCOL_VERSION = ProtocolVersion.CURRENT;

    public static Parameters defaults() {
        return ImmutableParameters.of();
    }

    public static ImmutableParameters.Builder builder() {
        return ImmutableParameters.builder();
    }

    @Value.Check
    protected void validate() {
        if (this.pageSize().isPresent() && this.pageSize().getAsInt() <= 0) {
            throw new IllegalStateException(String.format("Invalid page size %d: must be strictly positive", this.pageSize().getAsInt()));
        }
    }

    @Value.Default
    public ProtocolVersion protocolVersion() {
        return DEFAULT_PROTOCOL_VERSION;
    }

    public abstract OptionalInt pageSize();

    public abstract Optional<ByteBuffer> pagingState();

    @Value.Default
    public ConsistencyLevel consistencyLevel() {
        return DEFAULT_CONSISTENCY;
    }

    public abstract Optional<ConsistencyLevel> serialConsistencyLevel();

    public abstract OptionalLong defaultTimestamp();

    public abstract OptionalInt nowInSeconds();

    public abstract Optional<String> defaultKeyspace();

    public abstract Optional<Map<String, ByteBuffer>> customPayload();

    @Value.Default
    public boolean skipMetadataInResult() {
        return false;
    }

    @Value.Default
    public boolean tracingRequested() {
        return false;
    }

    public Parameters withConsistencyLevel(ConsistencyLevel newConsistencyLevel) {
        return this.toBuilder().consistencyLevel(newConsistencyLevel).build();
    }

    public Parameters withPagingState(@Nonnull ByteBuffer newPagingState) {
        return this.toBuilder().pagingState(newPagingState).build();
    }

    public Parameters withoutMetadataInResult() {
        return this.toBuilder().skipMetadataInResult(true).build();
    }

    public ImmutableParameters.Builder toBuilder() {
        return ImmutableParameters.builder().from(this);
    }

    public String toString() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (this.consistencyLevel() != DEFAULT_CONSISTENCY) {
            m.put("consistency", this.consistencyLevel().toString());
        }
        if (this.serialConsistencyLevel().isPresent()) {
            m.put("serial_consistency", this.serialConsistencyLevel().get().toString());
        }
        if (this.protocolVersion() != DEFAULT_PROTOCOL_VERSION) {
            m.put("protocol", this.protocolVersion().toString());
        }
        if (this.pageSize().isPresent() || this.pagingState().isPresent()) {
            String size = this.pageSize().isPresent() ? Integer.toString(this.pageSize().getAsInt()) : "unlimited";
            String state = this.pagingState().isPresent() ? " (continuation)" : "";
            m.put("paging", String.format("%s%s", size, state));
        }
        if (this.customPayload().isPresent()) {
            m.put("custom_payload", String.format("%d entries", this.customPayload().get().size()));
        }
        if (this.skipMetadataInResult()) {
            m.put("skipMetadata", "true");
        }
        if (this.tracingRequested()) {
            m.put("tracing", "true");
        }
        if (this.defaultKeyspace().isPresent()) {
            m.put("keyspace", this.defaultKeyspace().get());
        }
        if (this.defaultTimestamp().isPresent()) {
            m.put("timestamp", Long.toString(this.defaultTimestamp().getAsLong()));
        }
        if (this.nowInSeconds().isPresent()) {
            m.put("now", Integer.toString(this.nowInSeconds().getAsInt()));
        }
        return ((Object)m).toString();
    }
}

