/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db;

import io.stargate.db.AuthenticatedUser;
import io.stargate.db.Authenticator;
import io.stargate.db.Batch;
import io.stargate.db.ClientInfo;
import io.stargate.db.DbActivator;
import io.stargate.db.EventListener;
import io.stargate.db.PagingPosition;
import io.stargate.db.Parameters;
import io.stargate.db.Persistence;
import io.stargate.db.Result;
import io.stargate.db.RowDecorator;
import io.stargate.db.Statement;
import io.stargate.db.limiter.RateLimitingDecision;
import io.stargate.db.limiter.RateLimitingManager;
import io.stargate.db.schema.Schema;
import io.stargate.db.schema.TableName;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.cassandra.stargate.exceptions.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitingPersistence
implements Persistence {
    private static final Logger logger = LoggerFactory.getLogger(DbActivator.class);
    private final Persistence persistence;
    private final RateLimitingManager manager;

    public RateLimitingPersistence(Persistence persistence, RateLimitingManager manager) {
        this.persistence = persistence;
        this.manager = manager;
        logger.info("Enabling rate limiting: {}", (Object)manager.description());
    }

    @Override
    public String name() {
        return this.persistence.name();
    }

    @Override
    public Schema schema() {
        return this.persistence.schema();
    }

    @Override
    public void registerEventListener(EventListener listener) {
        this.persistence.registerEventListener(listener);
    }

    @Override
    public Authenticator getAuthenticator() {
        return this.persistence.getAuthenticator();
    }

    @Override
    public void setRpcReady(boolean status) {
        this.persistence.setRpcReady(status);
    }

    @Override
    public Persistence.Connection newConnection(ClientInfo clientInfo) {
        return new RateLimitedConnection(this.persistence.newConnection(clientInfo), this.manager.forNewConnection(clientInfo));
    }

    @Override
    public Persistence.Connection newConnection() {
        return new RateLimitedConnection(this.persistence.newConnection(), this.manager.forNewConnection());
    }

    @Override
    public ByteBuffer unsetValue() {
        return this.persistence.unsetValue();
    }

    @Override
    public boolean isInSchemaAgreement() {
        return this.persistence.isInSchemaAgreement();
    }

    @Override
    public boolean isInSchemaAgreementWithStorage() {
        return this.persistence.isInSchemaAgreementWithStorage();
    }

    @Override
    public boolean isSchemaAgreementAchievable() {
        return this.persistence.isSchemaAgreementAchievable();
    }

    @Override
    public boolean supportsSecondaryIndex() {
        return this.persistence.supportsSecondaryIndex();
    }

    @Override
    public boolean supportsSAI() {
        return this.persistence.supportsSAI();
    }

    @Override
    public Map<String, List<String>> cqlSupportedOptions() {
        return this.persistence.cqlSupportedOptions();
    }

    @Override
    public void executeAuthResponse(Runnable handler) {
        this.persistence.executeAuthResponse(handler);
    }

    private class RateLimitedConnection
    implements Persistence.Connection {
        private final Persistence.Connection connection;
        private final RateLimitingManager.ConnectionManager rateLimiter;

        private RateLimitedConnection(Persistence.Connection connection, RateLimitingManager.ConnectionManager rateLimiter) {
            this.connection = connection;
            this.rateLimiter = rateLimiter;
        }

        @Override
        public Persistence persistence() {
            return RateLimitingPersistence.this;
        }

        @Override
        public void login(AuthenticatedUser user) throws AuthenticationException {
            this.connection.login(user);
            this.rateLimiter.onUserLogged(user);
        }

        @Override
        public Optional<AuthenticatedUser> loggedUser() {
            return this.connection.loggedUser();
        }

        @Override
        public Optional<ClientInfo> clientInfo() {
            return this.connection.clientInfo();
        }

        @Override
        public Optional<String> usedKeyspace() {
            return this.connection.usedKeyspace();
        }

        @Override
        public CompletableFuture<Result.Prepared> prepare(String query, Parameters parameters) {
            RateLimitingDecision decision = this.rateLimiter.forPrepare(query, parameters);
            return decision.apply(() -> this.connection.prepare(query, parameters));
        }

        @Override
        public CompletableFuture<Result> execute(Statement statement, Parameters parameters, long queryStartNanoTime) {
            RateLimitingDecision decision = this.rateLimiter.forExecute(statement, parameters);
            return decision.apply(() -> this.connection.execute(statement, parameters, queryStartNanoTime));
        }

        @Override
        public CompletableFuture<Result> batch(Batch batch, Parameters parameters, long queryStartNanoTime) {
            RateLimitingDecision decision = this.rateLimiter.forBatch(batch, parameters);
            return decision.apply(() -> this.connection.batch(batch, parameters, queryStartNanoTime));
        }

        @Override
        public void setCustomProperties(Map<String, String> customProperties) {
            this.connection.setCustomProperties(customProperties);
        }

        @Override
        public ByteBuffer makePagingState(PagingPosition position, Parameters parameters) {
            return this.connection.makePagingState(position, parameters);
        }

        @Override
        public RowDecorator makeRowDecorator(TableName table) {
            return this.connection.makeRowDecorator(table);
        }
    }
}

