/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.limiter;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class AsyncRateLimiter {
    private final ScheduledExecutorService executor;
    private final long schedulingThresholdNanos;
    private volatile double nanosPerPermit;
    private final long reserveWindowNanos;
    private final AtomicLong consumedToTime;

    public AsyncRateLimiter(ScheduledExecutorService executor, long rate, TimeUnit rateUnit, long reserveWindow, TimeUnit reserveWindowUnit, long schedulingThreshold, TimeUnit schedulingThresholdUnit) {
        this.executor = executor;
        this.nanosPerPermit = (double)rateUnit.toNanos(1L) * 1.0 / (double)rate;
        this.reserveWindowNanos = reserveWindowUnit.toNanos(reserveWindow);
        this.consumedToTime = new AtomicLong(System.nanoTime());
        this.schedulingThresholdNanos = schedulingThresholdUnit.toNanos(schedulingThreshold);
    }

    public AsyncRateLimiter(ScheduledExecutorService executor, long rate, TimeUnit rateUnit, long reserveWindow, TimeUnit reserveWindowUnit) {
        this(executor, rate, rateUnit, reserveWindow, reserveWindowUnit, 1L, TimeUnit.MILLISECONDS);
    }

    public void setRate(long rate, TimeUnit rateUnit) {
        this.nanosPerPermit = (double)rateUnit.toNanos(1L) * 1.0 / (double)rate;
    }

    public long getRate(TimeUnit rateUnit) {
        return (long)((double)rateUnit.toNanos(1L) * 1.0 / this.nanosPerPermit);
    }

    private long acquire(long permits, long currentTimeNanos) {
        long scheduleTime;
        long consumedTo;
        if (permits <= 0L) {
            return currentTimeNanos;
        }
        long timeToAcquire = (long)((double)permits * this.nanosPerPermit);
        while (!this.consumedToTime.compareAndSet(consumedTo = this.consumedToTime.get(), (scheduleTime = Math.max(consumedTo, currentTimeNanos - this.reserveWindowNanos)) + timeToAcquire)) {
        }
        return scheduleTime;
    }

    public <T> CompletableFuture<T> acquireAndExecute(long permits, Supplier<CompletableFuture<T>> task) {
        long currentTime = System.nanoTime();
        long scheduleTime = this.acquire(permits, currentTime);
        long delay = scheduleTime - currentTime;
        if (delay < this.schedulingThresholdNanos) {
            return task.get();
        }
        CompletableFuture executionFuture = new CompletableFuture();
        this.executor.schedule(() -> ((CompletableFuture)task.get()).whenComplete((v, ex) -> AsyncRateLimiter.complete(executionFuture, v, ex)), delay, TimeUnit.NANOSECONDS);
        return executionFuture;
    }

    private static <T> void complete(CompletableFuture<T> toComplete, T result, Throwable exception) {
        if (exception != null) {
            toComplete.completeExceptionally(exception);
        } else {
            toComplete.complete(result);
        }
    }
}

