/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.metrics.api;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.stargate.db.ClientInfo;
import io.stargate.db.DriverInfo;

public interface ClientInfoMetricsTagProvider {
    public static final ClientInfoMetricsTagProvider DEFAULT = new ClientInfoMetricsTagProvider(){};
    public static final String TAG_KEY_DRIVER_NAME = "driverName";
    public static final String TAG_KEY_DRIVER_VERSION = "driverVersion";

    default public Tags getClientInfoTagsByDriver(ClientInfo clientInfo) {
        Tags tags = this.getClientInfoTags(clientInfo);
        if (clientInfo.driverInfo().isPresent()) {
            DriverInfo driverInfo = clientInfo.driverInfo().get();
            return tags.and(new Tag[]{Tag.of((String)TAG_KEY_DRIVER_NAME, (String)driverInfo.name())}).and(new Tag[]{Tag.of((String)TAG_KEY_DRIVER_VERSION, (String)driverInfo.version().orElse("unknown"))});
        }
        return tags.and(new Tag[]{Tag.of((String)TAG_KEY_DRIVER_NAME, (String)"unknown")}).and(new Tag[]{Tag.of((String)TAG_KEY_DRIVER_VERSION, (String)"unknown")});
    }

    default public Tags getClientInfoTags(ClientInfo clientInfo) {
        return Tags.empty();
    }
}

