/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.query.BindMarker;
import io.stargate.db.schema.Column;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="BindMarker", generator="Immutables")
@SuppressFBWarnings
@Immutable
final class ImmutableBindMarker
implements BindMarker {
    private final String receiver;
    private final Column.ColumnType type;

    private ImmutableBindMarker(String receiver, Column.ColumnType type) {
        this.receiver = receiver;
        this.type = type;
    }

    @Override
    public String receiver() {
        return this.receiver;
    }

    @Override
    public Column.ColumnType type() {
        return this.type;
    }

    public final ImmutableBindMarker withReceiver(String value) {
        String newValue = Objects.requireNonNull(value, "receiver");
        if (this.receiver.equals(newValue)) {
            return this;
        }
        return new ImmutableBindMarker(newValue, this.type);
    }

    public final ImmutableBindMarker withType(Column.ColumnType value) {
        if (this.type == value) {
            return this;
        }
        Column.ColumnType newValue = Objects.requireNonNull(value, "type");
        return new ImmutableBindMarker(this.receiver, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBindMarker && this.equalTo((ImmutableBindMarker)another);
    }

    private boolean equalTo(ImmutableBindMarker another) {
        return this.receiver.equals(another.receiver) && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.receiver.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "BindMarker{receiver=" + this.receiver + ", type=" + this.type + "}";
    }

    public static ImmutableBindMarker copyOf(BindMarker instance) {
        if (instance instanceof ImmutableBindMarker) {
            return (ImmutableBindMarker)instance;
        }
        return ImmutableBindMarker.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BindMarker", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RECEIVER = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private String receiver;
        @Nullable
        private Column.ColumnType type;

        private Builder() {
        }

        public final Builder from(BindMarker instance) {
            Objects.requireNonNull(instance, "instance");
            this.receiver(instance.receiver());
            this.type(instance.type());
            return this;
        }

        public final Builder receiver(String receiver) {
            this.receiver = Objects.requireNonNull(receiver, "receiver");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder type(Column.ColumnType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBindMarker build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBindMarker(this.receiver, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("receiver");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build BindMarker, some of required attributes are not set " + attributes;
        }
    }
}

