/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.query.ModifiableEntity;
import io.stargate.db.query.Modification;
import io.stargate.db.query.TypedValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Modification", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableModification
implements Modification {
    private final ModifiableEntity entity;
    private final Modification.Operation operation;
    @Nullable
    private final TypedValue value;

    private ImmutableModification(ModifiableEntity entity, Modification.Operation operation, @Nullable TypedValue value) {
        this.entity = entity;
        this.operation = operation;
        this.value = value;
    }

    @Override
    public ModifiableEntity entity() {
        return this.entity;
    }

    @Override
    public Modification.Operation operation() {
        return this.operation;
    }

    @Override
    @Nullable
    public TypedValue value() {
        return this.value;
    }

    public final ImmutableModification withEntity(ModifiableEntity value) {
        if (this.entity == value) {
            return this;
        }
        ModifiableEntity newValue = Objects.requireNonNull(value, "entity");
        return new ImmutableModification(newValue, this.operation, this.value);
    }

    public final ImmutableModification withOperation(Modification.Operation value) {
        if (this.operation == value) {
            return this;
        }
        Modification.Operation newValue = Objects.requireNonNull(value, "operation");
        if (this.operation.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableModification(this.entity, newValue, this.value);
    }

    public final ImmutableModification withValue(@Nullable TypedValue value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableModification(this.entity, this.operation, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableModification && this.equalTo((ImmutableModification)another);
    }

    private boolean equalTo(ImmutableModification another) {
        return this.entity.equals(another.entity) && this.operation.equals((Object)another.operation) && Objects.equals(this.value, another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.entity.hashCode();
        h += (h << 5) + this.operation.hashCode();
        h += (h << 5) + Objects.hashCode(this.value);
        return h;
    }

    public String toString() {
        return "Modification{entity=" + this.entity + ", operation=" + (Object)((Object)this.operation) + ", value=" + this.value + "}";
    }

    public static ImmutableModification copyOf(Modification instance) {
        if (instance instanceof ImmutableModification) {
            return (ImmutableModification)instance;
        }
        return ImmutableModification.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Modification", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENTITY = 1L;
        private static final long INIT_BIT_OPERATION = 2L;
        private long initBits = 3L;
        @Nullable
        private ModifiableEntity entity;
        @Nullable
        private Modification.Operation operation;
        @Nullable
        private TypedValue value;

        private Builder() {
        }

        public final Builder from(Modification instance) {
            Objects.requireNonNull(instance, "instance");
            this.entity(instance.entity());
            this.operation(instance.operation());
            TypedValue valueValue = instance.value();
            if (valueValue != null) {
                this.value(valueValue);
            }
            return this;
        }

        public final Builder entity(ModifiableEntity entity) {
            this.entity = Objects.requireNonNull(entity, "entity");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder operation(Modification.Operation operation) {
            this.operation = Objects.requireNonNull(operation, "operation");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder value(@Nullable TypedValue value) {
            this.value = value;
            return this;
        }

        public ImmutableModification build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableModification(this.entity, this.operation, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("entity");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("operation");
            }
            return "Cannot build Modification, some of required attributes are not set " + attributes;
        }
    }
}

