/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query;

import io.stargate.db.query.PartitionKey;
import io.stargate.db.query.TypedValue;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class RowsRange {
    private final PartitionKey partitionKey;
    private final Bound clusteringStart;
    private final Bound clusteringEnd;

    public RowsRange(PartitionKey partitionKey, Bound clusteringStart, Bound clusteringEnd) {
        this.partitionKey = partitionKey;
        this.clusteringStart = clusteringStart;
        this.clusteringEnd = clusteringEnd;
    }

    public PartitionKey partitionKey() {
        return this.partitionKey;
    }

    public Bound clusteringStart() {
        return this.clusteringStart;
    }

    public Bound clusteringEnd() {
        return this.clusteringEnd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RowsRange)) {
            return false;
        }
        RowsRange rowsRange = (RowsRange)o;
        return this.partitionKey.equals(rowsRange.partitionKey) && this.clusteringStart.equals(rowsRange.clusteringStart) && this.clusteringEnd.equals(rowsRange.clusteringEnd);
    }

    public int hashCode() {
        return Objects.hash(this.partitionKey, this.clusteringStart, this.clusteringEnd);
    }

    public static final class Bound {
        public static Bound EMPTY = new Bound(Collections.emptyList(), true);
        private final List<TypedValue> values;
        private final boolean isInclusive;

        public Bound(List<TypedValue> values, boolean isInclusive) {
            this.values = values;
            this.isInclusive = isInclusive;
        }

        public boolean isEmpty() {
            return this.values.isEmpty();
        }

        public List<TypedValue> values() {
            return this.values;
        }

        public boolean isInclusive() {
            return this.isInclusive;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Bound)) {
                return false;
            }
            Bound bound = (Bound)o;
            return this.isInclusive == bound.isInclusive && this.values.equals(bound.values);
        }

        public int hashCode() {
            return Objects.hash(this.values, this.isInclusive);
        }
    }
}

