/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import io.stargate.db.query.TypedValue;
import io.stargate.db.schema.AbstractTable;
import io.stargate.db.schema.Column;
import java.util.List;
import java.util.Objects;

public abstract class SchemaKey {
    protected final AbstractTable table;
    protected final List<TypedValue> values;

    public SchemaKey(AbstractTable table, List<TypedValue> values) {
        this.table = table;
        this.values = values;
        List<Column> keyColumns = this.allColumns();
        Preconditions.checkArgument(keyColumns.size() == values.size(), "Expected %s %s values, but only %s provided", (Object)keyColumns.size(), (Object)this.keyName(), (Object)values.size());
        for (int i = 0; i < keyColumns.size(); ++i) {
            Column.ColumnType expectedType = keyColumns.get(i).type();
            assert (expectedType != null);
            Column.ColumnType actualType = values.get(i).type();
            Preconditions.checkArgument(expectedType.equals(actualType), "Invalid type for value %s: expecting %s but got %s", (Object)i, (Object)expectedType, (Object)actualType);
        }
    }

    protected abstract String keyName();

    protected abstract int columnIndex(Column var1);

    public int size() {
        return this.values.size();
    }

    public TypedValue get(int i) {
        return this.values.get(i);
    }

    public TypedValue get(String name) {
        return this.get(this.table.existingColumn(name));
    }

    public TypedValue get(Column column) {
        return this.values.get(this.columnIndex(column));
    }

    public abstract List<Column> allColumns();

    public List<TypedValue> allValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaKey that = (SchemaKey)o;
        return this.table.keyspace().equals(that.table.keyspace()) && this.table.name().equals(that.table.name()) && this.values.equals(that.values);
    }

    public int hashCode() {
        return Objects.hash(this.table.keyspace(), this.table.name(), this.values);
    }

    public String toString() {
        return this.values.toString();
    }
}

