/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import io.stargate.db.Persistence;
import io.stargate.db.query.BindMarker;
import io.stargate.db.schema.Column;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cassandra.stargate.transport.ProtocolVersion;

public class TypedValue {
    public static final Object UNSET = new Object(){

        public String toString() {
            return "<unset>";
        }
    };
    private final Column.ColumnType type;
    @Nullable
    private final Object javaValue;
    @Nullable
    private final ByteBuffer bytesValue;

    private TypedValue(Column.ColumnType type, @Nullable Object javaValue, @Nullable ByteBuffer bytesValue) {
        Objects.requireNonNull(type);
        Preconditions.checkArgument(bytesValue != null || javaValue == null, "The bytes value should have been computed from the java value if the latter is not null");
        this.type = type;
        this.javaValue = javaValue;
        this.bytesValue = bytesValue;
    }

    public Column.ColumnType type() {
        return this.type;
    }

    public boolean isUnset() {
        return this.javaValue == UNSET;
    }

    @Nullable
    public Object javaValue() {
        return this.javaValue;
    }

    @Nullable
    public ByteBuffer bytes() {
        return this.bytesValue;
    }

    public static List<Object> javaValues(List<TypedValue> values) {
        ArrayList<Object> javaValues = new ArrayList<Object>(values.size());
        for (TypedValue value : values) {
            javaValues.add(value.javaValue());
        }
        return javaValues;
    }

    public static List<TypedValue> forJavaValues(Codec codec, List<BindMarker> markers, List<Object> values) {
        return TypedValue.makeBoundValues(codec, markers, values, TypedValue::forJavaValue);
    }

    public static List<TypedValue> forBytesValues(Codec codec, List<BindMarker> markers, List<ByteBuffer> values) {
        return TypedValue.makeBoundValues(codec, markers, values, TypedValue::forBytesValue);
    }

    private static <T> List<TypedValue> makeBoundValues(Codec codec, List<BindMarker> markers, List<T> values, BoundValueMaker<T> fct) {
        if (markers.size() != values.size()) {
            throw TypedValue.invalid("Unexpected number of values provided: expect %d values but %d provided", markers.size(), values.size());
        }
        ArrayList<TypedValue> boundValues = new ArrayList<TypedValue>(values.size());
        for (int i = 0; i < markers.size(); ++i) {
            boundValues.add(fct.make(codec, markers.get(i), values.get(i)));
        }
        return boundValues;
    }

    public static TypedValue forJavaValue(Codec codec, BindMarker marker, @Nullable Object value) {
        return TypedValue.forJavaValue(codec, marker.receiver(), marker.type(), value);
    }

    public static TypedValue forJavaValue(Codec codec, String name, Column.ColumnType type, @Nullable Object value) {
        if (value != null && value != UNSET) {
            value = TypedValue.validateValue(name, type, value);
        }
        return new TypedValue(type, value, codec.encode(type, value));
    }

    public static TypedValue forBytesValue(Codec codec, BindMarker marker, @Nullable ByteBuffer value) {
        return TypedValue.forBytesValue(codec, marker.type(), value);
    }

    public static TypedValue forBytesValue(Codec codec, Column.ColumnType type, @Nullable ByteBuffer value) {
        return new TypedValue(type, codec.decode(type, value), value);
    }

    private static Object validateValue(String name, Column.ColumnType type, Object value) {
        try {
            if (type.isList()) {
                if (!(value instanceof List)) {
                    throw TypedValue.invalid("For value bound to %s, expected a list but got a %s (%s)", name, value.getClass().getSimpleName(), value);
                }
                Column.ColumnType elementType = type.parameters().get(0);
                List list = (List)value;
                ArrayList<Object> validated = new ArrayList<Object>(list.size());
                for (Object e : list) {
                    validated.add(elementType.validate(e, name));
                }
                return validated;
            }
            if (type.isSet()) {
                if (!(value instanceof Set)) {
                    throw TypedValue.invalid("For value bound to %s, expected a set but got a %s (%s)", name, value.getClass().getSimpleName(), value);
                }
                Column.ColumnType elementType = type.parameters().get(0);
                Set set = (Set)value;
                HashSet<Object> validated = new HashSet<Object>();
                for (Object e : set) {
                    validated.add(elementType.validate(e, name));
                }
                return validated;
            }
            if (type.isMap()) {
                if (!(value instanceof Map)) {
                    throw TypedValue.invalid("For value bound to %s, expected a map but got a %s (%s)", name, value.getClass().getSimpleName(), value);
                }
                Column.ColumnType keyType = type.parameters().get(0);
                Column.ColumnType valueType = type.parameters().get(1);
                Map map = (Map)value;
                HashMap<Object, Object> validated = new HashMap<Object, Object>();
                for (Map.Entry e : map.entrySet()) {
                    validated.put(keyType.validate(e.getKey(), String.format("key of map %s", name)), valueType.validate(e.getValue(), String.format("value of map %s for key %s", name, e.getKey())));
                }
                return validated;
            }
            return type.validate(value, name);
        }
        catch (Column.ValidationException e) {
            throw TypedValue.invalid("Wrong value provided for column '%s'. Provided type '%s' is not compatible with expected CQL type '%s'.%s", e.location(), e.providedType(), e.expectedCqlType(), e.errorDetails());
        }
    }

    private static IllegalArgumentException invalid(String format, Object ... args) {
        return new IllegalArgumentException(String.format(format, args));
    }

    public boolean equals(Object o) {
        if (!(o instanceof TypedValue)) {
            return false;
        }
        TypedValue that = (TypedValue)o;
        return this.type.equals(that.type) && Objects.equals(this.bytesValue, that.bytesValue);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.bytesValue);
    }

    public String toString() {
        return this.javaValue == null ? "null" : this.type.codec().format(this.javaValue);
    }

    public static class Codec {
        private final ByteBuffer unset;
        private final com.datastax.oss.driver.api.core.ProtocolVersion driverProtocolVersion;

        public Codec(ProtocolVersion protocolVersion, Persistence persistence) {
            this(persistence.unsetValue(), protocolVersion.toDriverVersion());
        }

        private Codec(ByteBuffer unset, com.datastax.oss.driver.api.core.ProtocolVersion driverProtocolVersion) {
            this.unset = unset;
            this.driverProtocolVersion = driverProtocolVersion;
        }

        public static Codec testCodec() {
            return new Codec(ByteBuffer.allocate(0), com.datastax.oss.driver.api.core.ProtocolVersion.DEFAULT);
        }

        public ByteBuffer encode(@Nonnull Column.ColumnType type, Object value) {
            if (value == null) {
                return null;
            }
            if (value.equals(UNSET) || value.equals(this.unset)) {
                return this.unset;
            }
            return type.codec().encode(value, this.driverProtocolVersion);
        }

        public Object decode(@Nonnull Column.ColumnType type, ByteBuffer value) {
            if (value == null) {
                return null;
            }
            if (value.equals(this.unset)) {
                return UNSET;
            }
            return type.codec().decode(value, this.driverProtocolVersion);
        }
    }

    @FunctionalInterface
    private static interface BoundValueMaker<T> {
        public TypedValue make(Codec var1, BindMarker var2, T var3);
    }
}

