/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query.builder;

import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import io.stargate.db.Parameters;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.query.AsyncQueryExecutor;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.query.QueryType;
import io.stargate.db.query.TypedValue;
import io.stargate.db.query.builder.BuiltQuery;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import org.apache.cassandra.stargate.db.ConsistencyLevel;

@VisibleForTesting
public class AbstractBound<Q extends BuiltQuery<?>>
implements BoundQuery {
    private final BoundQuery.Source<Q> source;
    private final List<TypedValue> values;

    AbstractBound(Q builtQuery, List<TypedValue> boundedValues, List<TypedValue> values) {
        this.source = new BoundQuery.Source<Q>(builtQuery, boundedValues);
        this.values = values;
    }

    @Override
    public QueryType type() {
        return ((BuiltQuery)this.source.query()).type();
    }

    public BoundQuery.Source<Q> source() {
        return this.source;
    }

    @Override
    public List<TypedValue> values() {
        return this.values;
    }

    private AsyncQueryExecutor executor() {
        Preconditions.checkState(((BuiltQuery)this.source.query()).executor() != null, "Cannot execute query: it has no attached executor");
        return ((BuiltQuery)this.source.query()).executor();
    }

    public CompletableFuture<ResultSet> execute() {
        return this.executor().execute(this);
    }

    public CompletableFuture<ResultSet> execute(ConsistencyLevel consistencyLevel) {
        return this.executor().execute((BoundQuery)this, consistencyLevel);
    }

    public CompletableFuture<ResultSet> execute(UnaryOperator<Parameters> parametersModifier) {
        return this.executor().execute((BoundQuery)this, parametersModifier);
    }
}

