/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query.builder;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import io.stargate.db.query.AsyncQueryExecutor;
import io.stargate.db.query.BindMarker;
import io.stargate.db.query.Condition;
import io.stargate.db.query.ImmutableCondition;
import io.stargate.db.query.ImmutableModification;
import io.stargate.db.query.ModifiableEntity;
import io.stargate.db.query.Modification;
import io.stargate.db.query.Predicate;
import io.stargate.db.query.QueryType;
import io.stargate.db.query.RowsImpacted;
import io.stargate.db.query.TypedValue;
import io.stargate.db.query.builder.AbstractBound;
import io.stargate.db.query.builder.BuiltCondition;
import io.stargate.db.query.builder.BuiltQuery;
import io.stargate.db.query.builder.QueryStringBuilder;
import io.stargate.db.query.builder.Value;
import io.stargate.db.query.builder.ValueModifier;
import io.stargate.db.query.builder.WhereProcessor;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import org.apache.cassandra.stargate.utils.MD5Digest;

abstract class BuiltDML<Q extends AbstractBound<?>>
extends BuiltQuery<Q> {
    private final Table table;
    protected final DMLData data;

    protected BuiltDML(QueryType queryType, Table table, TypedValue.Codec codec, AsyncQueryExecutor executor, QueryStringBuilder builder, List<BuiltCondition> where, List<ValueModifier> modifiers, List<BuiltCondition> conditions, @Nullable Value<Integer> ttlValue, @Nullable Value<Long> timestampValue) {
        this(queryType, table, codec, null, executor, builder.externalBindMarkers(), new DMLData(builder.externalQueryString(), builder.internalBindMarkers(), builder.internalQueryString(), where, modifiers, conditions, ttlValue, timestampValue));
    }

    protected BuiltDML(QueryType queryType, Table table, TypedValue.Codec codec, @Nullable MD5Digest preparedId, AsyncQueryExecutor executor, List<BindMarker> externalBindMarkers, DMLData data) {
        super(queryType, codec, preparedId, executor, externalBindMarkers);
        this.table = table;
        this.data = data;
    }

    @Override
    public String queryStringForPreparation() {
        return this.data.internalQueryString;
    }

    public Table table() {
        return this.table;
    }

    @Override
    protected Q createBoundQuery(List<TypedValue> values) {
        BoundInfo info = new BoundInfo(this, values);
        info.handleWhereClause();
        info.handleRegularAndStaticModifications();
        info.handleTimestamp();
        info.handleTTL();
        info.handleConditions();
        return this.createBoundQuery(info);
    }

    protected abstract Q createBoundQuery(BoundInfo var1);

    @Override
    public final String toString() {
        return this.data.externalQueryString;
    }

    protected static class BoundInfo {
        private final BuiltDML<?> dml;
        private final List<TypedValue> boundValues;
        private final TypedValue[] internalBoundValues;
        private final WhereProcessor whereProcessor;
        private RowsImpacted rowsUpdated;
        private final List<Modification> modifications = new ArrayList<Modification>();
        private final List<Condition> conditions = new ArrayList<Condition>();
        private Integer ttl;
        private Long timestamp;

        BoundInfo(BuiltDML<?> dml, List<TypedValue> boundValues) {
            this.dml = dml;
            this.boundValues = boundValues;
            this.internalBoundValues = new TypedValue[dml.data.internalBindMarkerCount];
            this.whereProcessor = new WhereProcessor(((BuiltDML)dml).table, dml.valueCodec()){

                @Override
                protected TypedValue handleValue(String name, Column.ColumnType type, Value<?> value) {
                    return this.handleValue(name, type, value);
                }

                @Override
                protected void onNonColumnNameLHS(BuiltCondition.LHS lhs) {
                    throw new IllegalArgumentException(String.format("Invalid condition %s: cannot have condition on the sub-part of a primary key", lhs));
                }

                @Override
                protected void onNonPrimaryKeyCondition(Column column) {
                    throw new IllegalArgumentException(String.format("Invalid WHERE condition for DML on non primary key column %s", column.cqlName()));
                }

                @Override
                protected void onInequalityConditionOnPartitionKey(Column column, BuiltCondition condition) {
                    throw new IllegalArgumentException(String.format("Invalid condition %s for partition key %s", condition, column.cqlName()));
                }
            };
        }

        List<TypedValue> boundedValues() {
            return this.boundValues;
        }

        private void handleWhereClause() {
            this.rowsUpdated = this.whereProcessor.process(this.dml.data.where);
            if (this.rowsUpdated == null) {
                throw new IllegalArgumentException("Invalid WHERE clause: DML over a range of partitions are not supported");
            }
        }

        private void handleRegularAndStaticModifications() {
            for (ValueModifier modifier : this.dml.data.regularAndStaticModifiers) {
                Column column = ((BuiltDML)this.dml).table.existingColumn(modifier.target().columnName());
                ModifiableEntity entity = this.createEntity(column, modifier.target());
                TypedValue v = this.handleValue(entity.toString(), entity.type(), modifier.value());
                if (v.isUnset()) continue;
                this.modifications.add(ImmutableModification.builder().entity(entity).operation(modifier.operation()).value(v).build());
            }
        }

        private ModifiableEntity createEntity(Column column, ValueModifier.Target target) {
            if (target.fieldName() != null) {
                return ModifiableEntity.udtType(column, target.fieldName());
            }
            if (target.mapKey() != null) {
                Column.ColumnType type = column.type();
                Preconditions.checkArgument(type != null, "Provided column does not have its type set");
                Preconditions.checkArgument(type.isMap(), "Cannot access elements of column %s of type %s in %s, it is not a map", (Object)column.cqlName(), (Object)type, (Object)((BuiltDML)this.dml).table.cqlQualifiedName());
                Column.ColumnType keyType = type.parameters().get(0);
                Value<?> key = target.mapKey();
                TypedValue keyValue = this.dml.convertValue(key, "element of " + column.cqlName(), keyType, this.boundValues);
                Preconditions.checkArgument(!keyValue.isUnset(), "Cannot use UNSET for map column %s key in table %s", (Object)column.cqlName(), (Object)((BuiltDML)this.dml).table.cqlQualifiedName());
                return ModifiableEntity.mapValue(column, keyValue);
            }
            return ModifiableEntity.of(column);
        }

        private TypedValue handleValue(Column column, Value<?> value) {
            return this.handleValue(column.cqlName(), column.type(), value);
        }

        private TypedValue handleValue(String entityName, Column.ColumnType type, Value<?> value) {
            TypedValue v = this.dml.convertValue(value, entityName, type, this.boundValues);
            int internalIndex = value.internalIndex();
            if (internalIndex >= 0) {
                this.internalBoundValues[internalIndex] = v;
            }
            return v;
        }

        private void handleTTL() {
            if (this.dml.data.ttlValue == null) {
                return;
            }
            TypedValue v = this.handleValue(Column.TTL, this.dml.data.ttlValue);
            if (!v.isUnset()) {
                this.ttl = (Integer)v.javaValue();
                if (this.ttl == null) {
                    throw new IllegalArgumentException("Cannot pass null as bound value for the TTL");
                }
            }
        }

        private void handleTimestamp() {
            if (this.dml.data.timestampValue == null) {
                return;
            }
            TypedValue v = this.handleValue(Column.TIMESTAMP, this.dml.data.timestampValue);
            if (!v.isUnset()) {
                this.timestamp = (Long)v.javaValue();
                if (this.timestamp == null) {
                    throw new IllegalArgumentException("Cannot pass null as bound value for the TIMESTAMP");
                }
            }
        }

        private void handleConditions() {
            for (BuiltCondition bc : this.dml.data.conditions) {
                TypedValue v;
                Condition.LHS lhs = this.createLHS(bc.lhs());
                if (bc.predicate().equals((Object)Predicate.IN)) {
                    v = this.handleValue(lhs.toString(), Column.Type.List.of(lhs.valueType()), bc.value());
                } else if (bc.predicate().equals((Object)Predicate.CONTAINS)) {
                    v = this.handleValue(lhs.toString(), lhs.valueType().fieldType(lhs.toString()), bc.value());
                } else if (bc.predicate().equals((Object)Predicate.CONTAINS_KEY)) {
                    Column.ColumnType keyType = lhs.valueType().parameters().get(0);
                    v = this.handleValue(lhs.toString(), keyType, bc.value());
                } else {
                    v = this.handleValue(lhs.toString(), lhs.valueType(), bc.value());
                }
                if (lhs.isUnset() || v.isUnset()) continue;
                this.conditions.add(ImmutableCondition.builder().lhs(lhs).predicate(bc.predicate()).value(v).build());
            }
        }

        private Condition.LHS createLHS(BuiltCondition.LHS lhs) {
            if (lhs.isColumnName()) {
                String name = lhs.columnName();
                return Condition.LHS.column(((BuiltDML)this.dml).table.existingColumn(name));
            }
            if (lhs.isMapAccess()) {
                BuiltCondition.LHS.MapElement m = (BuiltCondition.LHS.MapElement)lhs;
                Column column = ((BuiltDML)this.dml).table.existingColumn(m.columnName());
                TypedValue v = this.handleValue(m.toString(), column.type().parameters().get(0), m.keyValue());
                return Condition.LHS.mapAccess(column, v);
            }
            throw new UnsupportedOperationException();
        }

        List<TypedValue> internalBoundValues() {
            return Arrays.asList(this.internalBoundValues);
        }

        RowsImpacted rowsUpdated() {
            return this.rowsUpdated;
        }

        List<Modification> modifications() {
            return this.modifications;
        }

        List<Condition> conditions() {
            return this.conditions;
        }

        OptionalInt ttl() {
            return this.ttl == null ? OptionalInt.empty() : OptionalInt.of(this.ttl);
        }

        OptionalLong timestamp() {
            return this.timestamp == null ? OptionalLong.empty() : OptionalLong.of(this.timestamp);
        }
    }

    protected static class DMLData {
        private final String externalQueryString;
        private final int internalBindMarkerCount;
        private final String internalQueryString;
        private final List<BuiltCondition> where;
        private final List<ValueModifier> regularAndStaticModifiers;
        private final List<BuiltCondition> conditions;
        @Nullable
        private final Value<Integer> ttlValue;
        @Nullable
        private final Value<Long> timestampValue;

        private DMLData(String externalQueryString, int internalBindMarkerCount, String internalQueryString, List<BuiltCondition> where, List<ValueModifier> regularAndStaticModifiers, List<BuiltCondition> ifConditions, @Nullable Value<Integer> ttlValue, @Nullable Value<Long> timestampValue) {
            this.externalQueryString = externalQueryString;
            this.internalBindMarkerCount = internalBindMarkerCount;
            this.internalQueryString = internalQueryString;
            this.where = where;
            this.regularAndStaticModifiers = regularAndStaticModifiers;
            this.conditions = ifConditions;
            this.ttlValue = ttlValue;
            this.timestampValue = timestampValue;
        }
    }
}

