/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query.builder;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.query.builder.ColumnOrder;
import io.stargate.db.schema.Column;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ColumnOrder", generator="Immutables")
@SuppressFBWarnings
@Immutable
final class ImmutableColumnOrder
extends ColumnOrder {
    private final String column;
    private final Column.Order order;
    private final transient int hashCode;

    private ImmutableColumnOrder(String column, Column.Order order) {
        this.column = column;
        this.order = order;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public String column() {
        return this.column;
    }

    @Override
    public Column.Order order() {
        return this.order;
    }

    public final ImmutableColumnOrder withColumn(String value) {
        String newValue = Objects.requireNonNull(value, "column");
        if (this.column.equals(newValue)) {
            return this;
        }
        return new ImmutableColumnOrder(newValue, this.order);
    }

    public final ImmutableColumnOrder withOrder(Column.Order value) {
        if (this.order == value) {
            return this;
        }
        Column.Order newValue = Objects.requireNonNull(value, "order");
        if (this.order.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableColumnOrder(this.column, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableColumnOrder && this.equalTo((ImmutableColumnOrder)another);
    }

    private boolean equalTo(ImmutableColumnOrder another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.column.equals(another.column) && this.order.equals((Object)another.order);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.column.hashCode();
        h += (h << 5) + this.order.hashCode();
        return h;
    }

    public static ImmutableColumnOrder copyOf(ColumnOrder instance) {
        if (instance instanceof ImmutableColumnOrder) {
            return (ImmutableColumnOrder)instance;
        }
        return ImmutableColumnOrder.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ColumnOrder", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COLUMN = 1L;
        private static final long INIT_BIT_ORDER = 2L;
        private long initBits = 3L;
        @Nullable
        private String column;
        @Nullable
        private Column.Order order;

        private Builder() {
        }

        public final Builder from(ColumnOrder instance) {
            Objects.requireNonNull(instance, "instance");
            this.column(instance.column());
            this.order(instance.order());
            return this;
        }

        public final Builder column(String column) {
            this.column = Objects.requireNonNull(column, "column");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder order(Column.Order order) {
            this.order = Objects.requireNonNull(order, "order");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableColumnOrder build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableColumnOrder(this.column, this.order);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("column");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("order");
            }
            return "Cannot build ColumnOrder, some of required attributes are not set " + attributes;
        }
    }
}

