/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query.builder;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.query.builder.Value;
import io.stargate.db.query.builder.ValueModifier;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ValueModifier.Target", generator="Immutables")
@SuppressFBWarnings
@Immutable
final class ImmutableTarget
extends ValueModifier.Target {
    private final String columnName;
    @Nullable
    private final String fieldName;
    @Nullable
    private final Value<?> mapKey;

    private ImmutableTarget(String columnName, @Nullable String fieldName, @Nullable Value<?> mapKey) {
        this.columnName = columnName;
        this.fieldName = fieldName;
        this.mapKey = mapKey;
    }

    @Override
    String columnName() {
        return this.columnName;
    }

    @Override
    @Nullable
    String fieldName() {
        return this.fieldName;
    }

    @Override
    @Nullable
    Value<?> mapKey() {
        return this.mapKey;
    }

    public final ImmutableTarget withColumnName(String value) {
        String newValue = Objects.requireNonNull(value, "columnName");
        if (this.columnName.equals(newValue)) {
            return this;
        }
        return new ImmutableTarget(newValue, this.fieldName, this.mapKey);
    }

    public final ImmutableTarget withFieldName(@Nullable String value) {
        if (Objects.equals(this.fieldName, value)) {
            return this;
        }
        return new ImmutableTarget(this.columnName, value, this.mapKey);
    }

    public final ImmutableTarget withMapKey(@Nullable Value<?> value) {
        if (this.mapKey == value) {
            return this;
        }
        return new ImmutableTarget(this.columnName, this.fieldName, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTarget && this.equalTo((ImmutableTarget)another);
    }

    private boolean equalTo(ImmutableTarget another) {
        return this.columnName.equals(another.columnName) && Objects.equals(this.fieldName, another.fieldName) && Objects.equals(this.mapKey, another.mapKey);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.columnName.hashCode();
        h += (h << 5) + Objects.hashCode(this.fieldName);
        h += (h << 5) + Objects.hashCode(this.mapKey);
        return h;
    }

    public String toString() {
        return "Target{columnName=" + this.columnName + ", fieldName=" + this.fieldName + ", mapKey=" + this.mapKey + "}";
    }

    public static ImmutableTarget copyOf(ValueModifier.Target instance) {
        if (instance instanceof ImmutableTarget) {
            return (ImmutableTarget)instance;
        }
        return ImmutableTarget.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ValueModifier.Target", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COLUMN_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String columnName;
        @Nullable
        private String fieldName;
        @Nullable
        private Value<?> mapKey;

        private Builder() {
        }

        public final Builder from(ValueModifier.Target instance) {
            Value<?> mapKeyValue;
            Objects.requireNonNull(instance, "instance");
            this.columnName(instance.columnName());
            String fieldNameValue = instance.fieldName();
            if (fieldNameValue != null) {
                this.fieldName(fieldNameValue);
            }
            if ((mapKeyValue = instance.mapKey()) != null) {
                this.mapKey(mapKeyValue);
            }
            return this;
        }

        public final Builder columnName(String columnName) {
            this.columnName = Objects.requireNonNull(columnName, "columnName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder fieldName(@Nullable String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final Builder mapKey(@Nullable Value<?> mapKey) {
            this.mapKey = mapKey;
            return this;
        }

        public ImmutableTarget build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTarget(this.columnName, this.fieldName, this.mapKey);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("columnName");
            }
            return "Cannot build Target, some of required attributes are not set " + attributes;
        }
    }
}

