/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query.builder;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.query.Modification;
import io.stargate.db.query.builder.Value;
import io.stargate.db.query.builder.ValueModifier;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ValueModifier", generator="Immutables")
@SuppressFBWarnings
@Immutable
final class ImmutableValueModifier
extends ValueModifier {
    private final ValueModifier.Target target;
    private final Modification.Operation operation;
    private final Value<?> value;

    private ImmutableValueModifier(ValueModifier.Target target, Modification.Operation operation, Value<?> value) {
        this.target = target;
        this.operation = operation;
        this.value = value;
    }

    @Override
    ValueModifier.Target target() {
        return this.target;
    }

    @Override
    Modification.Operation operation() {
        return this.operation;
    }

    @Override
    Value<?> value() {
        return this.value;
    }

    public final ImmutableValueModifier withTarget(ValueModifier.Target value) {
        if (this.target == value) {
            return this;
        }
        ValueModifier.Target newValue = Objects.requireNonNull(value, "target");
        return new ImmutableValueModifier(newValue, this.operation, this.value);
    }

    public final ImmutableValueModifier withOperation(Modification.Operation value) {
        if (this.operation == value) {
            return this;
        }
        Modification.Operation newValue = Objects.requireNonNull(value, "operation");
        if (this.operation.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableValueModifier(this.target, newValue, this.value);
    }

    public final ImmutableValueModifier withValue(Value<?> value) {
        if (this.value == value) {
            return this;
        }
        Value<?> newValue = Objects.requireNonNull(value, "value");
        return new ImmutableValueModifier(this.target, this.operation, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValueModifier && this.equalTo((ImmutableValueModifier)another);
    }

    private boolean equalTo(ImmutableValueModifier another) {
        return this.target.equals(another.target) && this.operation.equals((Object)another.operation) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.target.hashCode();
        h += (h << 5) + this.operation.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return "ValueModifier{target=" + this.target + ", operation=" + (Object)((Object)this.operation) + ", value=" + this.value + "}";
    }

    public static ImmutableValueModifier copyOf(ValueModifier instance) {
        if (instance instanceof ImmutableValueModifier) {
            return (ImmutableValueModifier)instance;
        }
        return ImmutableValueModifier.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ValueModifier", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TARGET = 1L;
        private static final long INIT_BIT_OPERATION = 2L;
        private static final long INIT_BIT_VALUE = 4L;
        private long initBits = 7L;
        @Nullable
        private ValueModifier.Target target;
        @Nullable
        private Modification.Operation operation;
        @Nullable
        private Value<?> value;

        private Builder() {
        }

        public final Builder from(ValueModifier instance) {
            Objects.requireNonNull(instance, "instance");
            this.target(instance.target());
            this.operation(instance.operation());
            this.value(instance.value());
            return this;
        }

        public final Builder target(ValueModifier.Target target) {
            this.target = Objects.requireNonNull(target, "target");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder operation(Modification.Operation operation) {
            this.operation = Objects.requireNonNull(operation, "operation");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder value(Value<?> value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableValueModifier build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValueModifier(this.target, this.operation, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("target");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("operation");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build ValueModifier, some of required attributes are not set " + attributes;
        }
    }
}

