/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query.builder;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import io.stargate.db.query.BindMarker;
import io.stargate.db.query.builder.Value;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.QualifiedSchemaEntity;
import io.stargate.db.schema.SchemaEntity;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

class QueryStringBuilder {
    private final StringBuilder internalBuilder = new StringBuilder();
    private final StringBuilder externalBuilder = new StringBuilder();
    private final BindMarker[] externalBindMarker;
    private int internalIndex = 0;

    QueryStringBuilder(int externalMarkers) {
        this.externalBindMarker = new BindMarker[externalMarkers];
    }

    private static boolean noSpaceBefore(char c) {
        switch (c) {
            case ' ': 
            case ')': 
            case ',': 
            case ']': {
                return true;
            }
        }
        return false;
    }

    private static boolean noSpaceAfter(char c) {
        switch (c) {
            case ' ': 
            case '(': 
            case '[': {
                return true;
            }
        }
        return false;
    }

    private static void maybeAddSpaceBefore(String str, StringBuilder builder) {
        if (str.isEmpty()) {
            return;
        }
        boolean noSpaceAfterPrev = builder.length() == 0 || QueryStringBuilder.noSpaceAfter(builder.charAt(builder.length() - 1));
        boolean noSpaceBeforeNew = QueryStringBuilder.noSpaceBefore(str.charAt(0));
        if (!noSpaceAfterPrev && !noSpaceBeforeNew) {
            builder.append(' ');
        }
    }

    private static void appendWithSpaceBefore(String str, StringBuilder builder) {
        QueryStringBuilder.maybeAddSpaceBefore(str, builder);
        builder.append(str);
    }

    private QueryStringBuilder appendWithSpaceBefore(String str) {
        QueryStringBuilder.appendWithSpaceBefore(str, this.internalBuilder);
        QueryStringBuilder.appendWithSpaceBefore(str, this.externalBuilder);
        return this;
    }

    private QueryStringBuilder appendBoth(String str) {
        this.internalBuilder.append(str);
        this.externalBuilder.append(str);
        return this;
    }

    private QueryStringBuilder appendBoth(String ... strings) {
        for (String str : strings) {
            this.appendBoth(str);
        }
        return this;
    }

    QueryStringBuilder append(String str) {
        return this.appendWithSpaceBefore(str.trim());
    }

    QueryStringBuilder appendForceNoSpace(String str) {
        return this.appendBoth(str.trim());
    }

    QueryStringBuilder append(QualifiedSchemaEntity entity) {
        this.appendWithSpaceBefore(entity.cqlKeyspace());
        this.appendBoth(".", entity.cqlName());
        return this;
    }

    QueryStringBuilder append(SchemaEntity entity) {
        return this.appendWithSpaceBefore(entity.cqlName());
    }

    QueryStringBuilder append(BindMarker marker, Value<?> value) {
        return this.append(marker, value, false);
    }

    QueryStringBuilder appendInValue(BindMarker marker, Value<?> value) {
        return this.append(marker, value, true);
    }

    private QueryStringBuilder append(BindMarker marker, Value<?> value, boolean isInValue) {
        value.setInternalIndex(this.internalIndex++);
        if (value.isMarker()) {
            this.externalBindMarker[((Value.Marker)value).externalIndex()] = marker;
            return this.appendWithSpaceBefore("?");
        }
        QueryStringBuilder.appendWithSpaceBefore("?", this.internalBuilder);
        Object concreteValue = value.get();
        if (isInValue) {
            Preconditions.checkArgument(concreteValue instanceof List, "On column %s, IN value must be a java List, but got %s of java type '%s'", (Object)marker.receiver(), concreteValue, (Object)concreteValue.getClass().getSimpleName());
            List values = (List)concreteValue;
            this.externalBuilder.append(" ");
            QueryStringBuilder.appendWithSpaceBefore("(", this.externalBuilder);
            Column.ColumnType subType = marker.type().parameters().get(0);
            for (int i = 0; i < values.size(); ++i) {
                if (i > 0) {
                    this.externalBuilder.append(", ");
                }
                String cqlValue = this.valueToString("value of " + marker.receiver(), subType, values.get(i));
                QueryStringBuilder.appendWithSpaceBefore(cqlValue, this.externalBuilder);
            }
            QueryStringBuilder.appendWithSpaceBefore(")", this.externalBuilder);
        } else {
            String cqlValue = this.valueToString(marker.receiver(), marker.type(), concreteValue);
            QueryStringBuilder.appendWithSpaceBefore(cqlValue, this.externalBuilder);
        }
        return this;
    }

    private String valueToString(String receiver, Column.ColumnType type, Object value) {
        try {
            return type.toCQLString(value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid value provided for '%s': %s", receiver, e.getMessage()), e);
        }
    }

    ListBuilder start() {
        return this.start("", ", ");
    }

    ListBuilder start(String opening) {
        return this.start(opening, ", ");
    }

    ListBuilder start(String opening, String separator) {
        return new ListBuilder(opening, separator, false);
    }

    ListBuilder lazyStart(String opening) {
        return this.lazyStart(opening, ", ");
    }

    ListBuilder lazyStart(String opening, String separator) {
        return new ListBuilder(opening, separator, true);
    }

    List<BindMarker> externalBindMarkers() {
        List<BindMarker> markers = Arrays.asList(this.externalBindMarker);
        Preconditions.checkState(markers.stream().noneMatch(Objects::isNull));
        return markers;
    }

    int internalBindMarkers() {
        return this.internalIndex;
    }

    public String internalQueryString() {
        return this.internalBuilder.toString();
    }

    public String externalQueryString() {
        return this.externalBuilder.toString();
    }

    public String toString() {
        return String.format("{internal=%s, external=%s}", this.internalQueryString(), this.externalQueryString());
    }

    class ListBuilder {
        private final String opening;
        private final String separator;
        private final boolean ignoreEmpty;
        private boolean isFirst = true;

        private ListBuilder(String opening, String separator, boolean ignoreEmpty) {
            this.opening = opening;
            this.separator = separator;
            this.ignoreEmpty = ignoreEmpty;
        }

        private void beforeElement() {
            if (this.isFirst) {
                QueryStringBuilder.this.appendWithSpaceBefore(this.opening);
                this.isFirst = false;
            } else {
                QueryStringBuilder.this.appendWithSpaceBefore(this.separator);
            }
        }

        <T extends SchemaEntity> ListBuilder addAll(List<T> l) {
            return this.addAll(l, QueryStringBuilder.this::append);
        }

        <T> ListBuilder addAll(List<T> l, Consumer<T> onElement) {
            return this.addAllWithIdx(l, (e, i) -> onElement.accept(e));
        }

        <T> ListBuilder addAllWithIdx(List<T> l, BiConsumer<T, Integer> onElement) {
            for (int i = 0; i < l.size(); ++i) {
                this.beforeElement();
                onElement.accept(l.get(i), i);
            }
            return this;
        }

        <T> ListBuilder addIfNotNull(T element, Consumer<T> onElement) {
            if (element != null) {
                this.beforeElement();
                onElement.accept(element);
            }
            return this;
        }

        <T> ListBuilder addIf(boolean condition, Runnable onTrue) {
            if (condition) {
                this.beforeElement();
                onTrue.run();
            }
            return this;
        }

        QueryStringBuilder end() {
            return this.end("");
        }

        QueryStringBuilder end(String ending) {
            if (this.isFirst) {
                if (!this.ignoreEmpty) {
                    QueryStringBuilder.this.appendWithSpaceBefore(this.opening).appendWithSpaceBefore(ending);
                }
            } else {
                QueryStringBuilder.this.appendWithSpaceBefore(ending);
            }
            return QueryStringBuilder.this;
        }
    }
}

