/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query.builder;

import io.stargate.db.query.Modification;
import io.stargate.db.query.builder.ImmutableTarget;
import io.stargate.db.query.builder.ImmutableValueModifier;
import io.stargate.db.query.builder.Value;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Value.Immutable
@Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE)
public abstract class ValueModifier {
    abstract Target target();

    abstract Modification.Operation operation();

    abstract Value<?> value();

    public static ValueModifier set(String columnName, Object value) {
        return ValueModifier.of(columnName, Value.of(value));
    }

    public static ValueModifier marker(String columnName) {
        return ValueModifier.of(columnName, Value.marker());
    }

    public static ValueModifier of(String columnName, Value<?> value) {
        return ImmutableValueModifier.builder().target(Target.of(columnName)).operation(Modification.Operation.SET).value(value).build();
    }

    public static ValueModifier of(String columnName, Value<?> value, Modification.Operation operation) {
        return ImmutableValueModifier.builder().target(Target.of(columnName)).operation(operation).value(value).build();
    }

    @Value.Immutable
    @Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE)
    static abstract class Target {
        Target() {
        }

        abstract String columnName();

        @Nullable
        abstract String fieldName();

        @Nullable
        abstract Value<?> mapKey();

        static Target of(String columnName) {
            return ImmutableTarget.builder().columnName(columnName).build();
        }
    }
}

