/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.query.builder;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import io.stargate.db.query.PartitionKey;
import io.stargate.db.query.Predicate;
import io.stargate.db.query.PrimaryKey;
import io.stargate.db.query.RowsImpacted;
import io.stargate.db.query.RowsRange;
import io.stargate.db.query.TypedValue;
import io.stargate.db.query.builder.BuiltCondition;
import io.stargate.db.query.builder.Value;
import io.stargate.db.schema.AbstractTable;
import io.stargate.db.schema.Column;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.javatuples.Pair;

abstract class WhereProcessor {
    private final AbstractTable table;
    private final TypedValue.Codec valueCodec;
    private final List<Column> primaryKeys;
    private final PKCondition[] pkConditions;
    private boolean shouldIgnorePkConditions;

    WhereProcessor(AbstractTable table, TypedValue.Codec valueCodec) {
        this.table = table;
        this.valueCodec = valueCodec;
        this.primaryKeys = table.primaryKeyColumns();
        this.pkConditions = new PKCondition[this.primaryKeys.size()];
    }

    protected abstract TypedValue handleValue(String var1, Column.ColumnType var2, Value<?> var3);

    protected void onNonColumnNameLHS(BuiltCondition.LHS lhs) {
    }

    protected void onNonPrimaryKeyCondition(Column column) {
    }

    protected void onInequalityConditionOnPartitionKey(Column column, BuiltCondition condition) {
    }

    @Nullable
    RowsImpacted process(List<BuiltCondition> whereClause) {
        this.preProcess(whereClause);
        if (this.shouldIgnorePkConditions) {
            return null;
        }
        switch (this.kind()) {
            case KEYS: {
                return this.createKeys();
            }
            case SINGLE_PARTITION_SLICE: {
                return this.createRange();
            }
        }
        return null;
    }

    private SelectionKind kind() {
        for (int i = 0; i < this.primaryKeys.size(); ++i) {
            Column column = this.primaryKeys.get(i);
            PKCondition pkCondition = this.pkConditions[i];
            if (pkCondition != null && pkCondition.isEqOrIn()) continue;
            return column.isPartitionKey() ? SelectionKind.PARTITION_RANGE : SelectionKind.SINGLE_PARTITION_SLICE;
        }
        return SelectionKind.KEYS;
    }

    private RowsImpacted.Ranges createRange() {
        Pair<List<List<TypedValue>>, Integer> p = this.populateEqAndIn(this.primaryKeys, this.pkConditions);
        int firstNonEq = p.getValue1();
        assert (firstNonEq < this.primaryKeys.size());
        assert (firstNonEq >= this.table.partitionKeyColumns().size()) : firstNonEq + ": " + this.table.partitionKeyColumns();
        List<List<TypedValue>> pkValues = p.getValue0();
        PKCondition condition = this.pkConditions[firstNonEq];
        int partitionKeys = this.table.partitionKeyColumns().size();
        ArrayList<RowsRange> ranges = new ArrayList<RowsRange>(pkValues.size());
        for (List<TypedValue> pkPrefix : pkValues) {
            PartitionKey partitionKey = new PartitionKey(this.table, pkPrefix.subList(0, partitionKeys));
            List<TypedValue> startValues = pkPrefix = pkPrefix.subList(partitionKeys, pkPrefix.size());
            boolean startInclusive = true;
            List<TypedValue> endValues = pkPrefix;
            boolean endInclusive = true;
            if (condition != null) {
                startValues = new ArrayList<TypedValue>(pkPrefix);
                startValues.add(condition.values[0]);
                startInclusive = condition.isInclusive[0];
                endValues = new ArrayList<TypedValue>(pkPrefix);
                endValues.add(condition.values[1]);
                endInclusive = condition.isInclusive[1];
            }
            RowsRange.Bound start = new RowsRange.Bound(startValues, startInclusive);
            RowsRange.Bound end = new RowsRange.Bound(endValues, endInclusive);
            ranges.add(new RowsRange(partitionKey, start, end));
        }
        return new RowsImpacted.Ranges(ranges);
    }

    private RowsImpacted.Keys createKeys() {
        Pair<List<List<TypedValue>>, Integer> p = this.populateEqAndIn(this.primaryKeys, this.pkConditions);
        Preconditions.checkArgument(p.getValue1().intValue() == this.primaryKeys.size(), "Invalid condition combinations on primary key columns");
        List<List<TypedValue>> pkValues = p.getValue0();
        ArrayList<PrimaryKey> keys = new ArrayList<PrimaryKey>(pkValues.size());
        for (List<TypedValue> pkValue : pkValues) {
            keys.add(new PrimaryKey(this.table, pkValue));
        }
        return new RowsImpacted.Keys(keys);
    }

    private Pair<List<List<TypedValue>>, Integer> populateEqAndIn(List<Column> primaryKeys, PKCondition[] pkConditions) {
        ArrayList pkValues = new ArrayList();
        pkValues.add(new ArrayList());
        for (int i = 0; i < primaryKeys.size(); ++i) {
            Column column = primaryKeys.get(i);
            PKCondition condition = pkConditions[i];
            if (condition == null || !condition.isEqOrIn()) {
                return Pair.with(pkValues, i);
            }
            TypedValue value = condition.values[0];
            if (condition.isEq()) {
                for (List list : pkValues) {
                    list.add(value);
                }
                continue;
            }
            assert (value.javaValue() instanceof List);
            List inValues = (List)value.javaValue();
            List list = inValues.stream().map(o -> TypedValue.forJavaValue(this.valueCodec, column.name(), column.type(), o)).collect(Collectors.toList());
            ArrayList currentValues = pkValues;
            pkValues = new ArrayList();
            for (List list2 : currentValues) {
                for (TypedValue newValue : list) {
                    ArrayList<TypedValue> newValues = new ArrayList<TypedValue>(list2);
                    newValues.add(newValue);
                    pkValues.add(newValues);
                }
            }
        }
        return Pair.with(pkValues, primaryKeys.size());
    }

    void preProcess(List<BuiltCondition> whereClause) {
        for (BuiltCondition condition : whereClause) {
            BuiltCondition.LHS lhs = condition.lhs();
            Column column = this.table.existingColumn(lhs.columnName());
            if (!column.isPrimaryKeyComponent()) {
                this.onNonPrimaryKeyCondition(column);
                continue;
            }
            if (!lhs.isColumnName()) {
                this.onNonColumnNameLHS(lhs);
                this.shouldIgnorePkConditions = true;
                return;
            }
            int idx = this.table.primaryKeyColumnIndex(column);
            PKCondition pkCondition = this.compute(column, this.pkConditions[idx], condition);
            if (pkCondition == PKCondition.INVALID) {
                this.shouldIgnorePkConditions = true;
                return;
            }
            this.pkConditions[idx] = pkCondition;
        }
    }

    private static boolean isEqOrIn(BuiltCondition condition) {
        return condition.predicate() == Predicate.EQ || condition.predicate() == Predicate.IN;
    }

    private static int rangeIdx(BuiltCondition condition) {
        switch (condition.predicate()) {
            case GT: 
            case GTE: {
                return 0;
            }
            case LT: 
            case LTE: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Invalidate condition on primary key column: " + condition);
    }

    private static boolean isInclusive(BuiltCondition condition) {
        switch (condition.predicate()) {
            case GTE: 
            case LTE: {
                return true;
            }
            case GT: 
            case LT: {
                return false;
            }
        }
        throw new AssertionError();
    }

    private PKCondition compute(Column column, PKCondition existing, BuiltCondition condition) {
        TypedValue v = condition.predicate() == Predicate.IN ? this.handleValue(String.format("in(%s)", column.name()), Column.Type.List.of(column.type()), condition.value()) : this.handleValue(column.name(), column.type(), condition.value());
        Preconditions.checkArgument(v.bytes() != null, "Cannot use a null value for primary key column %s in table %s", (Object)column.cqlName(), (Object)this.table.cqlQualifiedName());
        if (v.isUnset()) {
            return existing;
        }
        if (WhereProcessor.isEqOrIn(condition)) {
            if (existing != null) {
                throw new IllegalArgumentException(String.format("Incompatible conditions %s and %s", existing.firstCondition, condition));
            }
            PKCondition pkCondition = new PKCondition(condition);
            ((PKCondition)pkCondition).values[0] = v;
            return pkCondition;
        }
        if (column.isPartitionKey()) {
            this.onInequalityConditionOnPartitionKey(column, condition);
            return PKCondition.INVALID;
        }
        if (existing == null) {
            existing = new PKCondition(condition);
        } else {
            Preconditions.checkArgument(!existing.isEqOrIn(), "Incompatible conditions %s and %s", (Object)existing.firstCondition, (Object)condition);
        }
        int idx = WhereProcessor.rangeIdx(condition);
        Preconditions.checkArgument(existing.values[idx] == null, "Incompatible conditions %s and %s", (Object)existing.firstCondition, (Object)condition);
        ((PKCondition)existing).values[idx] = v;
        ((PKCondition)existing).isInclusive[idx] = WhereProcessor.isInclusive(condition);
        return existing;
    }

    private static class PKCondition {
        private static final PKCondition INVALID = new PKCondition(null);
        private final BuiltCondition firstCondition;
        private final TypedValue[] values = new TypedValue[2];
        private final boolean[] isInclusive = new boolean[2];

        private PKCondition(BuiltCondition firstCondition) {
            this.firstCondition = firstCondition;
        }

        private boolean isEq() {
            return this.firstCondition.predicate() == Predicate.EQ;
        }

        private boolean isEqOrIn() {
            return WhereProcessor.isEqOrIn(this.firstCondition);
        }
    }

    private static enum SelectionKind {
        KEYS,
        SINGLE_PARTITION_SLICE,
        PARTITION_RANGE;

    }
}

