/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.SchemaEntity;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Column", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableColumn
extends Column {
    @Nullable
    private final String keyspace;
    @Nullable
    private final String table;
    private final String name;
    @Nullable
    private final Column.Kind kind;
    @Nullable
    private final Column.ColumnType type;
    @Nullable
    private final Column.Order order;
    private final int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long CQL_NAME_LAZY_INIT_BIT = 1L;
    private transient String cqlName;
    private static final long serialVersionUID = 2199514488330101566L;

    private ImmutableColumn(@Nullable String keyspace, @Nullable String table, String name, @Nullable Column.Kind kind, @Nullable Column.ColumnType type) {
        this.keyspace = keyspace;
        this.table = table;
        this.name = Objects.requireNonNull(name, "name");
        this.kind = kind;
        this.type = type;
        this.order = super.order();
        this.hashCode = this.computeHashCode();
    }

    private ImmutableColumn(Builder builder) {
        this.keyspace = builder.keyspace;
        this.table = builder.table;
        this.name = builder.name;
        this.kind = builder.kind;
        this.type = builder.type;
        this.order = builder.orderIsSet() ? builder.order : super.order();
        this.hashCode = this.computeHashCode();
    }

    private ImmutableColumn(@Nullable String keyspace, @Nullable String table, String name, @Nullable Column.Kind kind, @Nullable Column.ColumnType type, @Nullable Column.Order order) {
        this.keyspace = keyspace;
        this.table = table;
        this.name = name;
        this.kind = kind;
        this.type = type;
        this.order = order;
        this.hashCode = this.computeHashCode();
    }

    @Override
    @Nullable
    public String keyspace() {
        return this.keyspace;
    }

    @Override
    @Nullable
    public String table() {
        return this.table;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public Column.Kind kind() {
        return this.kind;
    }

    @Override
    @Nullable
    public Column.ColumnType type() {
        return this.type;
    }

    @Override
    @Nullable
    public Column.Order order() {
        return this.order;
    }

    public final ImmutableColumn withKeyspace(@Nullable String value) {
        if (Objects.equals(this.keyspace, value)) {
            return this;
        }
        return new ImmutableColumn(value, this.table, this.name, this.kind, this.type, this.order);
    }

    public final ImmutableColumn withTable(@Nullable String value) {
        if (Objects.equals(this.table, value)) {
            return this;
        }
        return new ImmutableColumn(this.keyspace, value, this.name, this.kind, this.type, this.order);
    }

    public final ImmutableColumn withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableColumn(this.keyspace, this.table, newValue, this.kind, this.type, this.order);
    }

    public final ImmutableColumn withKind(@Nullable Column.Kind value) {
        if (this.kind == value) {
            return this;
        }
        if (Objects.equals((Object)this.kind, (Object)value)) {
            return this;
        }
        return new ImmutableColumn(this.keyspace, this.table, this.name, value, this.type, this.order);
    }

    public final ImmutableColumn withType(@Nullable Column.ColumnType value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableColumn(this.keyspace, this.table, this.name, this.kind, value, this.order);
    }

    public final ImmutableColumn withOrder(@Nullable Column.Order value) {
        if (this.order == value) {
            return this;
        }
        if (Objects.equals((Object)this.order, (Object)value)) {
            return this;
        }
        return new ImmutableColumn(this.keyspace, this.table, this.name, this.kind, this.type, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableColumn && this.equalTo((ImmutableColumn)another);
    }

    private boolean equalTo(ImmutableColumn another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.keyspace, another.keyspace) && Objects.equals(this.table, another.table) && this.name.equals(another.name) && Objects.equals((Object)this.kind, (Object)another.kind) && Objects.equals(this.type, another.type) && Objects.equals((Object)this.order, (Object)another.order);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.keyspace);
        h += (h << 5) + Objects.hashCode(this.table);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.kind);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode((Object)this.order);
        return h;
    }

    public String toString() {
        return "Column{keyspace=" + this.keyspace + ", table=" + this.table + ", name=" + this.name + ", kind=" + (Object)((Object)this.kind) + ", type=" + this.type + ", order=" + (Object)((Object)this.order) + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String cqlName() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableColumn immutableColumn = this;
            synchronized (immutableColumn) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.cqlName = Objects.requireNonNull(super.cqlName(), "cqlName");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.cqlName;
    }

    public static ImmutableColumn of(@Nullable String keyspace, @Nullable String table, String name, @Nullable Column.Kind kind, @Nullable Column.ColumnType type) {
        return new ImmutableColumn(keyspace, table, name, kind, type);
    }

    public static ImmutableColumn copyOf(Column instance) {
        if (instance instanceof ImmutableColumn) {
            return (ImmutableColumn)instance;
        }
        return ImmutableColumn.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return new ImmutableColumn(this.keyspace, this.table, this.name, this.kind, this.type, this.order);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Column", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements Column.Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long OPT_BIT_ORDER = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String keyspace;
        @Nullable
        private String table;
        @Nullable
        private String name;
        @Nullable
        private Column.Kind kind;
        @Nullable
        private Column.ColumnType type;
        @Nullable
        private Column.Order order;

        private Builder() {
        }

        public final Builder from(SchemaEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Column instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SchemaEntity instance;
            long bits = 0L;
            if (object instanceof SchemaEntity) {
                instance = (SchemaEntity)object;
                if ((bits & 1L) == 0L) {
                    this.name(instance.name());
                    bits |= 1L;
                }
            }
            if (object instanceof Column) {
                Column.Order orderValue;
                String tableValue;
                Column.Kind kindValue;
                Column.ColumnType typeValue;
                String keyspaceValue;
                instance = (Column)object;
                if ((bits & 1L) == 0L) {
                    this.name(((Column)instance).name());
                    bits |= 1L;
                }
                if ((keyspaceValue = ((Column)instance).keyspace()) != null) {
                    this.keyspace(keyspaceValue);
                }
                if ((typeValue = ((Column)instance).type()) != null) {
                    this.type(typeValue);
                }
                if ((kindValue = ((Column)instance).kind()) != null) {
                    this.kind(kindValue);
                }
                if ((tableValue = ((Column)instance).table()) != null) {
                    this.table(tableValue);
                }
                if ((orderValue = ((Column)instance).order()) != null) {
                    this.order(orderValue);
                }
            }
        }

        public final Builder keyspace(@Nullable String keyspace) {
            this.keyspace = keyspace;
            return this;
        }

        public final Builder table(@Nullable String table) {
            this.table = table;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder kind(@Nullable Column.Kind kind) {
            this.kind = kind;
            return this;
        }

        @Override
        public final Builder type(@Nullable Column.ColumnType type) {
            this.type = type;
            return this;
        }

        public final Builder order(@Nullable Column.Order order) {
            this.order = order;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableColumn build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableColumn(this);
        }

        private boolean orderIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Column, some of required attributes are not set " + attributes;
        }
    }
}

