/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.schema.ColumnMappingMetadata;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ColumnMappingMetadata", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableColumnMappingMetadata
extends ColumnMappingMetadata {
    private final String vertexColumn;
    private final String edgeColumn;
    private final int hashCode;

    private ImmutableColumnMappingMetadata(String vertexColumn, String edgeColumn) {
        this.vertexColumn = vertexColumn;
        this.edgeColumn = edgeColumn;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public String vertexColumn() {
        return this.vertexColumn;
    }

    @Override
    public String edgeColumn() {
        return this.edgeColumn;
    }

    public final ImmutableColumnMappingMetadata withVertexColumn(String value) {
        String newValue = Objects.requireNonNull(value, "vertexColumn");
        if (this.vertexColumn.equals(newValue)) {
            return this;
        }
        return new ImmutableColumnMappingMetadata(newValue, this.edgeColumn);
    }

    public final ImmutableColumnMappingMetadata withEdgeColumn(String value) {
        String newValue = Objects.requireNonNull(value, "edgeColumn");
        if (this.edgeColumn.equals(newValue)) {
            return this;
        }
        return new ImmutableColumnMappingMetadata(this.vertexColumn, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableColumnMappingMetadata && this.equalTo((ImmutableColumnMappingMetadata)another);
    }

    private boolean equalTo(ImmutableColumnMappingMetadata another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.vertexColumn.equals(another.vertexColumn) && this.edgeColumn.equals(another.edgeColumn);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.vertexColumn.hashCode();
        h += (h << 5) + this.edgeColumn.hashCode();
        return h;
    }

    public String toString() {
        return "ColumnMappingMetadata{vertexColumn=" + this.vertexColumn + ", edgeColumn=" + this.edgeColumn + "}";
    }

    public static ImmutableColumnMappingMetadata copyOf(ColumnMappingMetadata instance) {
        if (instance instanceof ImmutableColumnMappingMetadata) {
            return (ImmutableColumnMappingMetadata)instance;
        }
        return ImmutableColumnMappingMetadata.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return new ImmutableColumnMappingMetadata(this.vertexColumn, this.edgeColumn);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ColumnMappingMetadata", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VERTEX_COLUMN = 1L;
        private static final long INIT_BIT_EDGE_COLUMN = 2L;
        private long initBits = 3L;
        @Nullable
        private String vertexColumn;
        @Nullable
        private String edgeColumn;

        private Builder() {
        }

        public final Builder from(ColumnMappingMetadata instance) {
            Objects.requireNonNull(instance, "instance");
            this.vertexColumn(instance.vertexColumn());
            this.edgeColumn(instance.edgeColumn());
            return this;
        }

        public final Builder vertexColumn(String vertexColumn) {
            this.vertexColumn = Objects.requireNonNull(vertexColumn, "vertexColumn");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder edgeColumn(String edgeColumn) {
            this.edgeColumn = Objects.requireNonNull(edgeColumn, "edgeColumn");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableColumnMappingMetadata build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableColumnMappingMetadata(this.vertexColumn, this.edgeColumn);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("vertexColumn");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("edgeColumn");
            }
            return "Cannot build ColumnMappingMetadata, some of required attributes are not set " + attributes;
        }
    }
}

