/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Schema", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableSchema
extends Schema {
    private final Set<Keyspace> keyspaces;
    private final transient int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long KEYSPACE_MAP_LAZY_INIT_BIT = 1L;
    private transient Map<String, Keyspace> keyspaceMap;

    private ImmutableSchema(Set<Keyspace> keyspaces) {
        this.keyspaces = keyspaces;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public Set<Keyspace> keyspaces() {
        return this.keyspaces;
    }

    public final ImmutableSchema withKeyspaces(Keyspace ... elements) {
        Set<Keyspace> newValue = ImmutableSchema.createUnmodifiableSet(ImmutableSchema.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSchema(newValue);
    }

    public final ImmutableSchema withKeyspaces(Iterable<? extends Keyspace> elements) {
        if (this.keyspaces == elements) {
            return this;
        }
        Set<Keyspace> newValue = ImmutableSchema.createUnmodifiableSet(ImmutableSchema.createSafeList(elements, true, false));
        return new ImmutableSchema(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSchema && this.equalTo((ImmutableSchema)another);
    }

    private boolean equalTo(ImmutableSchema another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.keyspaces.equals(another.keyspaces);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.keyspaces.hashCode();
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Map<String, Keyspace> keyspaceMap() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableSchema immutableSchema = this;
            synchronized (immutableSchema) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.keyspaceMap = Objects.requireNonNull(super.keyspaceMap(), "keyspaceMap");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.keyspaceMap;
    }

    public static ImmutableSchema copyOf(Schema instance) {
        if (instance instanceof ImmutableSchema) {
            return (ImmutableSchema)instance;
        }
        return ImmutableSchema.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="Schema", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<Keyspace> keyspaces = new ArrayList<Keyspace>();

        private Builder() {
        }

        public final Builder from(Schema instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllKeyspaces(instance.keyspaces());
            return this;
        }

        public final Builder addKeyspaces(Keyspace element) {
            this.keyspaces.add(Objects.requireNonNull(element, "keyspaces element"));
            return this;
        }

        public final Builder addKeyspaces(Keyspace ... elements) {
            for (Keyspace element : elements) {
                this.keyspaces.add(Objects.requireNonNull(element, "keyspaces element"));
            }
            return this;
        }

        public final Builder keyspaces(Iterable<? extends Keyspace> elements) {
            this.keyspaces.clear();
            return this.addAllKeyspaces(elements);
        }

        public final Builder addAllKeyspaces(Iterable<? extends Keyspace> elements) {
            for (Keyspace keyspace : elements) {
                this.keyspaces.add(Objects.requireNonNull(keyspace, "keyspaces element"));
            }
            return this;
        }

        public ImmutableSchema build() {
            return new ImmutableSchema(ImmutableSchema.createUnmodifiableSet(this.keyspaces));
        }
    }
}

