/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.schema.AbstractTable;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Index;
import io.stargate.db.schema.QualifiedSchemaEntity;
import io.stargate.db.schema.SchemaEntity;
import io.stargate.db.schema.Table;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Table", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableTable
extends Table {
    private final String name;
    private final String keyspace;
    private final List<Column> columns;
    private final List<Index> indexes;
    private final String comment;
    private final int ttl;
    private final int hashCode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long CQL_NAME_LAZY_INIT_BIT = 1L;
    private transient String cqlName;
    private static final long CQL_KEYSPACE_LAZY_INIT_BIT = 2L;
    private transient String cqlKeyspace;
    private static final long CQL_QUALIFIED_NAME_LAZY_INIT_BIT = 4L;
    private transient String cqlQualifiedName;
    private static final long COLUMN_MAP_LAZY_INIT_BIT = 8L;
    private transient Map<String, Column> columnMap;
    private static final long PARTITION_KEY_COLUMNS_LAZY_INIT_BIT = 16L;
    private transient List<Column> partitionKeyColumns;
    private static final long CLUSTERING_KEY_COLUMNS_LAZY_INIT_BIT = 32L;
    private transient List<Column> clusteringKeyColumns;
    private static final long PRIMARY_KEY_COLUMNS_LAZY_INIT_BIT = 64L;
    private transient List<Column> primaryKeyColumns;
    private static final long REGULAR_AND_STATIC_COLUMNS_LAZY_INIT_BIT = 128L;
    private transient List<Column> regularAndStaticColumns;
    private static final long REQUIRED_INDEX_COLUMNS_LAZY_INIT_BIT = 256L;
    private transient Set<Column> requiredIndexColumns;
    private static final long OPTIONAL_INDEX_COLUMNS_LAZY_INIT_BIT = 512L;
    private transient Set<Column> optionalIndexColumns;
    private static final long INDEX_MAP_LAZY_INIT_BIT = 1024L;
    private transient Map<String, Index> indexMap;
    private static final long serialVersionUID = 5913904335622827700L;

    private ImmutableTable(Builder builder) {
        this.name = builder.name;
        this.keyspace = builder.keyspace;
        this.columns = ImmutableTable.createUnmodifiableList(true, builder.columns);
        this.indexes = ImmutableTable.createUnmodifiableList(true, builder.indexes);
        if (builder.comment != null) {
            this.initShim.comment(builder.comment);
        }
        if (builder.ttlIsSet()) {
            this.initShim.ttl(builder.ttl);
        }
        this.comment = this.initShim.comment();
        this.ttl = this.initShim.ttl();
        this.hashCode = this.computeHashCode();
        this.initShim = null;
    }

    private ImmutableTable(String name, String keyspace, List<Column> columns, List<Index> indexes, String comment, int ttl) {
        this.name = name;
        this.keyspace = keyspace;
        this.columns = columns;
        this.indexes = indexes;
        this.comment = comment;
        this.ttl = ttl;
        this.hashCode = this.computeHashCode();
        this.initShim = null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String keyspace() {
        return this.keyspace;
    }

    @Override
    public List<Column> columns() {
        return this.columns;
    }

    @Override
    public List<Index> indexes() {
        return this.indexes;
    }

    @Override
    public String comment() {
        InitShim shim = this.initShim;
        return shim != null ? shim.comment() : this.comment;
    }

    @Override
    public int ttl() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ttl() : this.ttl;
    }

    public final ImmutableTable withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableTable(newValue, this.keyspace, this.columns, this.indexes, this.comment, this.ttl);
    }

    public final ImmutableTable withKeyspace(String value) {
        String newValue = Objects.requireNonNull(value, "keyspace");
        if (this.keyspace.equals(newValue)) {
            return this;
        }
        return new ImmutableTable(this.name, newValue, this.columns, this.indexes, this.comment, this.ttl);
    }

    public final ImmutableTable withColumns(Column ... elements) {
        List<Column> newValue = ImmutableTable.createUnmodifiableList(false, ImmutableTable.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableTable(this.name, this.keyspace, newValue, this.indexes, this.comment, this.ttl);
    }

    public final ImmutableTable withColumns(Iterable<? extends Column> elements) {
        if (this.columns == elements) {
            return this;
        }
        List<Column> newValue = ImmutableTable.createUnmodifiableList(false, ImmutableTable.createSafeList(elements, true, false));
        return new ImmutableTable(this.name, this.keyspace, newValue, this.indexes, this.comment, this.ttl);
    }

    public final ImmutableTable withIndexes(Index ... elements) {
        List<Index> newValue = ImmutableTable.createUnmodifiableList(false, ImmutableTable.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableTable(this.name, this.keyspace, this.columns, newValue, this.comment, this.ttl);
    }

    public final ImmutableTable withIndexes(Iterable<? extends Index> elements) {
        if (this.indexes == elements) {
            return this;
        }
        List<Index> newValue = ImmutableTable.createUnmodifiableList(false, ImmutableTable.createSafeList(elements, true, false));
        return new ImmutableTable(this.name, this.keyspace, this.columns, newValue, this.comment, this.ttl);
    }

    public final ImmutableTable withComment(String value) {
        String newValue = Objects.requireNonNull(value, "comment");
        if (this.comment.equals(newValue)) {
            return this;
        }
        return new ImmutableTable(this.name, this.keyspace, this.columns, this.indexes, newValue, this.ttl);
    }

    public final ImmutableTable withTtl(int value) {
        if (this.ttl == value) {
            return this;
        }
        return new ImmutableTable(this.name, this.keyspace, this.columns, this.indexes, this.comment, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTable && this.equalTo((ImmutableTable)another);
    }

    private boolean equalTo(ImmutableTable another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.name.equals(another.name) && this.keyspace.equals(another.keyspace) && this.columns.equals(another.columns) && this.indexes.equals(another.indexes) && this.comment.equals(another.comment) && this.ttl == another.ttl;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.keyspace.hashCode();
        h += (h << 5) + this.columns.hashCode();
        h += (h << 5) + this.indexes.hashCode();
        h += (h << 5) + this.comment.hashCode();
        h += (h << 5) + this.ttl;
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String cqlName() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableTable immutableTable = this;
            synchronized (immutableTable) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.cqlName = Objects.requireNonNull(super.cqlName(), "cqlName");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.cqlName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String cqlKeyspace() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableTable immutableTable = this;
            synchronized (immutableTable) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.cqlKeyspace = Objects.requireNonNull(super.cqlKeyspace(), "cqlKeyspace");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.cqlKeyspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String cqlQualifiedName() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableTable immutableTable = this;
            synchronized (immutableTable) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.cqlQualifiedName = Objects.requireNonNull(super.cqlQualifiedName(), "cqlQualifiedName");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.cqlQualifiedName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Map<String, Column> columnMap() {
        if ((this.lazyInitBitmap & 8L) == 0L) {
            ImmutableTable immutableTable = this;
            synchronized (immutableTable) {
                if ((this.lazyInitBitmap & 8L) == 0L) {
                    this.columnMap = Objects.requireNonNull(super.columnMap(), "columnMap");
                    this.lazyInitBitmap |= 8L;
                }
            }
        }
        return this.columnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Column> partitionKeyColumns() {
        if ((this.lazyInitBitmap & 0x10L) == 0L) {
            ImmutableTable immutableTable = this;
            synchronized (immutableTable) {
                if ((this.lazyInitBitmap & 0x10L) == 0L) {
                    this.partitionKeyColumns = Objects.requireNonNull(super.partitionKeyColumns(), "partitionKeyColumns");
                    this.lazyInitBitmap |= 0x10L;
                }
            }
        }
        return this.partitionKeyColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Column> clusteringKeyColumns() {
        if ((this.lazyInitBitmap & 0x20L) == 0L) {
            ImmutableTable immutableTable = this;
            synchronized (immutableTable) {
                if ((this.lazyInitBitmap & 0x20L) == 0L) {
                    this.clusteringKeyColumns = Objects.requireNonNull(super.clusteringKeyColumns(), "clusteringKeyColumns");
                    this.lazyInitBitmap |= 0x20L;
                }
            }
        }
        return this.clusteringKeyColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Column> primaryKeyColumns() {
        if ((this.lazyInitBitmap & 0x40L) == 0L) {
            ImmutableTable immutableTable = this;
            synchronized (immutableTable) {
                if ((this.lazyInitBitmap & 0x40L) == 0L) {
                    this.primaryKeyColumns = Objects.requireNonNull(super.primaryKeyColumns(), "primaryKeyColumns");
                    this.lazyInitBitmap |= 0x40L;
                }
            }
        }
        return this.primaryKeyColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Column> regularAndStaticColumns() {
        if ((this.lazyInitBitmap & 0x80L) == 0L) {
            ImmutableTable immutableTable = this;
            synchronized (immutableTable) {
                if ((this.lazyInitBitmap & 0x80L) == 0L) {
                    this.regularAndStaticColumns = Objects.requireNonNull(super.regularAndStaticColumns(), "regularAndStaticColumns");
                    this.lazyInitBitmap |= 0x80L;
                }
            }
        }
        return this.regularAndStaticColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Column> getRequiredIndexColumns() {
        if ((this.lazyInitBitmap & 0x100L) == 0L) {
            ImmutableTable immutableTable = this;
            synchronized (immutableTable) {
                if ((this.lazyInitBitmap & 0x100L) == 0L) {
                    this.requiredIndexColumns = Objects.requireNonNull(super.getRequiredIndexColumns(), "requiredIndexColumns");
                    this.lazyInitBitmap |= 0x100L;
                }
            }
        }
        return this.requiredIndexColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Column> getOptionalIndexColumns() {
        if ((this.lazyInitBitmap & 0x200L) == 0L) {
            ImmutableTable immutableTable = this;
            synchronized (immutableTable) {
                if ((this.lazyInitBitmap & 0x200L) == 0L) {
                    this.optionalIndexColumns = Objects.requireNonNull(super.getOptionalIndexColumns(), "optionalIndexColumns");
                    this.lazyInitBitmap |= 0x200L;
                }
            }
        }
        return this.optionalIndexColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Map<String, Index> indexMap() {
        if ((this.lazyInitBitmap & 0x400L) == 0L) {
            ImmutableTable immutableTable = this;
            synchronized (immutableTable) {
                if ((this.lazyInitBitmap & 0x400L) == 0L) {
                    this.indexMap = Objects.requireNonNull(super.indexMap(), "indexMap");
                    this.lazyInitBitmap |= 0x400L;
                }
            }
        }
        return this.indexMap;
    }

    public static ImmutableTable copyOf(Table instance) {
        if (instance instanceof ImmutableTable) {
            return (ImmutableTable)instance;
        }
        return ImmutableTable.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return new ImmutableTable(this.name, this.keyspace, this.columns, this.indexes, this.comment, this.ttl);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Table", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_KEYSPACE = 2L;
        private static final long OPT_BIT_TTL = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String name;
        @Nullable
        private String keyspace;
        private List<Column> columns = new ArrayList<Column>();
        private List<Index> indexes = new ArrayList<Index>();
        @Nullable
        private String comment;
        private int ttl;

        private Builder() {
        }

        public final Builder from(SchemaEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(QualifiedSchemaEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractTable instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Table instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SchemaEntity instance;
            long bits = 0L;
            if (object instanceof SchemaEntity) {
                instance = (SchemaEntity)object;
                this.name(instance.name());
            }
            if (object instanceof QualifiedSchemaEntity) {
                instance = (QualifiedSchemaEntity)object;
                this.keyspace(instance.keyspace());
            }
            if (object instanceof AbstractTable) {
                instance = (AbstractTable)object;
                if ((bits & 2L) == 0L) {
                    this.ttl(((AbstractTable)instance).ttl());
                    bits |= 2L;
                }
                this.addAllColumns(((AbstractTable)instance).columns());
                if ((bits & 1L) == 0L) {
                    this.comment(((AbstractTable)instance).comment());
                    bits |= 1L;
                }
            }
            if (object instanceof Table) {
                instance = (Table)object;
                this.addAllIndexes(((Table)instance).indexes());
                if ((bits & 2L) == 0L) {
                    this.ttl(((Table)instance).ttl());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.comment(((Table)instance).comment());
                    bits |= 1L;
                }
            }
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder keyspace(String keyspace) {
            this.keyspace = Objects.requireNonNull(keyspace, "keyspace");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addColumns(Column element) {
            this.columns.add(Objects.requireNonNull(element, "columns element"));
            return this;
        }

        public final Builder addColumns(Column ... elements) {
            for (Column element : elements) {
                this.columns.add(Objects.requireNonNull(element, "columns element"));
            }
            return this;
        }

        public final Builder columns(Iterable<? extends Column> elements) {
            this.columns.clear();
            return this.addAllColumns(elements);
        }

        public final Builder addAllColumns(Iterable<? extends Column> elements) {
            for (Column column : elements) {
                this.columns.add(Objects.requireNonNull(column, "columns element"));
            }
            return this;
        }

        public final Builder addIndexes(Index element) {
            this.indexes.add(Objects.requireNonNull(element, "indexes element"));
            return this;
        }

        public final Builder addIndexes(Index ... elements) {
            for (Index element : elements) {
                this.indexes.add(Objects.requireNonNull(element, "indexes element"));
            }
            return this;
        }

        public final Builder indexes(Iterable<? extends Index> elements) {
            this.indexes.clear();
            return this.addAllIndexes(elements);
        }

        public final Builder addAllIndexes(Iterable<? extends Index> elements) {
            for (Index index : elements) {
                this.indexes.add(Objects.requireNonNull(index, "indexes element"));
            }
            return this;
        }

        public final Builder comment(String comment) {
            this.comment = Objects.requireNonNull(comment, "comment");
            return this;
        }

        public final Builder ttl(int ttl) {
            this.ttl = ttl;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableTable build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTable(this);
        }

        private boolean ttlIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("keyspace");
            }
            return "Cannot build Table, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="Table", generator="Immutables")
    private final class InitShim {
        private byte commentBuildStage = 0;
        private String comment;
        private byte ttlBuildStage = 0;
        private int ttl;

        private InitShim() {
        }

        String comment() {
            if (this.commentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.commentBuildStage == 0) {
                this.commentBuildStage = (byte)-1;
                this.comment = Objects.requireNonNull(ImmutableTable.super.comment(), "comment");
                this.commentBuildStage = 1;
            }
            return this.comment;
        }

        void comment(String comment) {
            this.comment = comment;
            this.commentBuildStage = 1;
        }

        int ttl() {
            if (this.ttlBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ttlBuildStage == 0) {
                this.ttlBuildStage = (byte)-1;
                this.ttl = ImmutableTable.super.ttl();
                this.ttlBuildStage = 1;
            }
            return this.ttl;
        }

        void ttl(int ttl) {
            this.ttl = ttl;
            this.ttlBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.commentBuildStage == -1) {
                attributes.add("comment");
            }
            if (this.ttlBuildStage == -1) {
                attributes.add("ttl");
            }
            return "Cannot build Table, attribute initializers form cycle " + attributes;
        }
    }
}

