/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.schema.QualifiedSchemaEntity;
import io.stargate.db.schema.SchemaEntity;
import io.stargate.db.schema.TableName;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="TableName", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableTableName
implements TableName {
    private final String name;
    private final String keyspace;
    private volatile transient long lazyInitBitmap;
    private static final long CQL_NAME_LAZY_INIT_BIT = 1L;
    private transient String cqlName;
    private static final long CQL_KEYSPACE_LAZY_INIT_BIT = 2L;
    private transient String cqlKeyspace;
    private static final long CQL_QUALIFIED_NAME_LAZY_INIT_BIT = 4L;
    private transient String cqlQualifiedName;

    private ImmutableTableName(String name, String keyspace) {
        this.name = name;
        this.keyspace = keyspace;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String keyspace() {
        return this.keyspace;
    }

    public final ImmutableTableName withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableTableName(newValue, this.keyspace);
    }

    public final ImmutableTableName withKeyspace(String value) {
        String newValue = Objects.requireNonNull(value, "keyspace");
        if (this.keyspace.equals(newValue)) {
            return this;
        }
        return new ImmutableTableName(this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTableName && this.equalTo((ImmutableTableName)another);
    }

    private boolean equalTo(ImmutableTableName another) {
        return this.name.equals(another.name) && this.keyspace.equals(another.keyspace);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.keyspace.hashCode();
        return h;
    }

    public String toString() {
        return "TableName{name=" + this.name + ", keyspace=" + this.keyspace + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String cqlName() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableTableName immutableTableName = this;
            synchronized (immutableTableName) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.cqlName = Objects.requireNonNull(TableName.super.cqlName(), "cqlName");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.cqlName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String cqlKeyspace() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableTableName immutableTableName = this;
            synchronized (immutableTableName) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.cqlKeyspace = Objects.requireNonNull(TableName.super.cqlKeyspace(), "cqlKeyspace");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.cqlKeyspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String cqlQualifiedName() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableTableName immutableTableName = this;
            synchronized (immutableTableName) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.cqlQualifiedName = Objects.requireNonNull(TableName.super.cqlQualifiedName(), "cqlQualifiedName");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.cqlQualifiedName;
    }

    public static ImmutableTableName copyOf(TableName instance) {
        if (instance instanceof ImmutableTableName) {
            return (ImmutableTableName)instance;
        }
        return ImmutableTableName.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TableName", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_KEYSPACE = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private String keyspace;

        private Builder() {
        }

        public final Builder from(SchemaEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(QualifiedSchemaEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TableName instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SchemaEntity instance;
            if (object instanceof SchemaEntity) {
                instance = (SchemaEntity)object;
                this.name(instance.name());
            }
            if (object instanceof QualifiedSchemaEntity) {
                instance = (QualifiedSchemaEntity)object;
                this.keyspace(instance.keyspace());
            }
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder keyspace(String keyspace) {
            this.keyspace = Objects.requireNonNull(keyspace, "keyspace");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTableName build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTableName(this.name, this.keyspace);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("keyspace");
            }
            return "Cannot build TableName, some of required attributes are not set " + attributes;
        }
    }
}

