/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.SchemaEntity;
import io.stargate.db.schema.SchemaHashable;
import io.stargate.db.schema.UserDefinedType;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="UserDefinedType", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableUserDefinedType
extends UserDefinedType {
    private final boolean isFrozen;
    private final String name;
    private final String keyspace;
    private final List<Column> columns;
    private final int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long CQL_NAME_LAZY_INIT_BIT = 1L;
    private transient String cqlName;
    private static final long COLUMN_MAP_LAZY_INIT_BIT = 2L;
    private transient Map<String, Column> columnMap;
    private static final long CODEC_LAZY_INIT_BIT = 4L;
    private transient TypeCodec codec;

    private ImmutableUserDefinedType(Builder builder) {
        this.name = builder.name;
        this.keyspace = builder.keyspace;
        this.columns = ImmutableUserDefinedType.createUnmodifiableList(true, builder.columns);
        this.isFrozen = builder.isFrozenIsSet() ? builder.isFrozen : super.isFrozen();
        this.hashCode = this.computeHashCode();
    }

    private ImmutableUserDefinedType(boolean isFrozen, String name, String keyspace, List<Column> columns) {
        this.isFrozen = isFrozen;
        this.name = name;
        this.keyspace = keyspace;
        this.columns = columns;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public boolean isFrozen() {
        return this.isFrozen;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String keyspace() {
        return this.keyspace;
    }

    @Override
    public List<Column> columns() {
        return this.columns;
    }

    public final ImmutableUserDefinedType withIsFrozen(boolean value) {
        if (this.isFrozen == value) {
            return this;
        }
        return new ImmutableUserDefinedType(value, this.name, this.keyspace, this.columns);
    }

    public final ImmutableUserDefinedType withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableUserDefinedType(this.isFrozen, newValue, this.keyspace, this.columns);
    }

    public final ImmutableUserDefinedType withKeyspace(String value) {
        String newValue = Objects.requireNonNull(value, "keyspace");
        if (this.keyspace.equals(newValue)) {
            return this;
        }
        return new ImmutableUserDefinedType(this.isFrozen, this.name, newValue, this.columns);
    }

    public final ImmutableUserDefinedType withColumns(Column ... elements) {
        List<Column> newValue = ImmutableUserDefinedType.createUnmodifiableList(false, ImmutableUserDefinedType.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUserDefinedType(this.isFrozen, this.name, this.keyspace, newValue);
    }

    public final ImmutableUserDefinedType withColumns(Iterable<? extends Column> elements) {
        if (this.columns == elements) {
            return this;
        }
        List<Column> newValue = ImmutableUserDefinedType.createUnmodifiableList(false, ImmutableUserDefinedType.createSafeList(elements, true, false));
        return new ImmutableUserDefinedType(this.isFrozen, this.name, this.keyspace, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUserDefinedType && this.equalTo((ImmutableUserDefinedType)another);
    }

    private boolean equalTo(ImmutableUserDefinedType another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.isFrozen == another.isFrozen && this.name.equals(another.name) && this.keyspace.equals(another.keyspace) && this.columns.equals(another.columns);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.isFrozen);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.keyspace.hashCode();
        h += (h << 5) + this.columns.hashCode();
        return h;
    }

    public String toString() {
        return "UserDefinedType{isFrozen=" + this.isFrozen + ", name=" + this.name + ", keyspace=" + this.keyspace + ", columns=" + this.columns + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String cqlName() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableUserDefinedType immutableUserDefinedType = this;
            synchronized (immutableUserDefinedType) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.cqlName = Objects.requireNonNull(super.cqlName(), "cqlName");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.cqlName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Column> columnMap() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableUserDefinedType immutableUserDefinedType = this;
            synchronized (immutableUserDefinedType) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.columnMap = Objects.requireNonNull(super.columnMap(), "columnMap");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.columnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeCodec codec() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableUserDefinedType immutableUserDefinedType = this;
            synchronized (immutableUserDefinedType) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.codec = Objects.requireNonNull(super.codec(), "codec");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.codec;
    }

    public static ImmutableUserDefinedType copyOf(UserDefinedType instance) {
        if (instance instanceof ImmutableUserDefinedType) {
            return (ImmutableUserDefinedType)instance;
        }
        return ImmutableUserDefinedType.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return new ImmutableUserDefinedType(this.isFrozen, this.name, this.keyspace, this.columns);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="UserDefinedType", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_KEYSPACE = 2L;
        private static final long OPT_BIT_IS_FROZEN = 1L;
        private long initBits = 3L;
        private long optBits;
        private boolean isFrozen;
        @Nullable
        private String name;
        @Nullable
        private String keyspace;
        private List<Column> columns = new ArrayList<Column>();

        private Builder() {
        }

        public final Builder from(SchemaEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UserDefinedType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Column.ColumnType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SchemaHashable instance;
            long bits = 0L;
            if (object instanceof SchemaEntity) {
                instance = (SchemaEntity)object;
                if ((bits & 1L) == 0L) {
                    this.name(instance.name());
                    bits |= 1L;
                }
            }
            if (object instanceof UserDefinedType) {
                instance = (UserDefinedType)object;
                this.keyspace(((UserDefinedType)instance).keyspace());
                this.addAllColumns(((UserDefinedType)instance).columns());
            }
            if (object instanceof Column.ColumnType) {
                instance = (Column.ColumnType)object;
                if ((bits & 1L) == 0L) {
                    this.name(instance.name());
                    bits |= 1L;
                }
                this.isFrozen(instance.isFrozen());
            }
        }

        public final Builder isFrozen(boolean isFrozen) {
            this.isFrozen = isFrozen;
            this.optBits |= 1L;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder keyspace(String keyspace) {
            this.keyspace = Objects.requireNonNull(keyspace, "keyspace");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addColumns(Column element) {
            this.columns.add(Objects.requireNonNull(element, "columns element"));
            return this;
        }

        public final Builder addColumns(Column ... elements) {
            for (Column element : elements) {
                this.columns.add(Objects.requireNonNull(element, "columns element"));
            }
            return this;
        }

        public final Builder columns(Iterable<? extends Column> elements) {
            this.columns.clear();
            return this.addAllColumns(elements);
        }

        public final Builder addAllColumns(Iterable<? extends Column> elements) {
            for (Column column : elements) {
                this.columns.add(Objects.requireNonNull(column, "columns element"));
            }
            return this;
        }

        public ImmutableUserDefinedType build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUserDefinedType(this);
        }

        private boolean isFrozenIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("keyspace");
            }
            return "Cannot build UserDefinedType, some of required attributes are not set " + attributes;
        }
    }
}

