/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableTableName;
import io.stargate.db.schema.QualifiedSchemaEntity;
import io.stargate.db.schema.SchemaHashable;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public interface TableName
extends QualifiedSchemaEntity {
    public static TableName of(Collection<Column> columns) {
        Set tables = columns.stream().map(column -> ImmutableTableName.builder().keyspace(Objects.requireNonNull(column.keyspace())).name(Objects.requireNonNull(column.table())).build()).collect(Collectors.toSet());
        if (tables.isEmpty()) {
            throw new IllegalArgumentException("Missing table information in the provided set of columns.");
        }
        if (tables.size() > 1) {
            throw new IllegalArgumentException("Too many tables are referenced: " + tables);
        }
        return (TableName)tables.iterator().next();
    }

    @Override
    default public int schemaHashCode() {
        return SchemaHashable.combine(SchemaHashable.hashCode(this.keyspace()), SchemaHashable.hashCode(this.name()));
    }
}

