/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.schema;

import io.stargate.db.schema.Column;
import io.stargate.db.schema.SchemaHashable;

public class VectorType
extends Column.DelegatingColumnType {
    private final String elementTypeName;
    private final int dimensions;
    private final String marshalTypeName;

    protected VectorType(String elementTypeName, int dimensions) {
        super(Column.Type.Vector);
        this.elementTypeName = elementTypeName;
        this.dimensions = dimensions;
        this.marshalTypeName = String.format("org.apache.cassandra.db.marshal.VectorType(%s, %s)", elementTypeName, dimensions);
    }

    public static VectorType of(String elementTypeName, int dimensions) {
        return new VectorType(elementTypeName, dimensions);
    }

    @Override
    public String marshalTypeName() {
        return this.marshalTypeName;
    }

    @Override
    public int schemaHashCode() {
        return this.delegate.schemaHashCode() ^ SchemaHashable.hashCode(this.elementTypeName) + this.dimensions;
    }
}

