/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema;

import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLType;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.FieldTypeCache;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.SchemaWarningException;
import io.stargate.graphql.schema.types.MapBuilder;
import io.stargate.graphql.schema.types.TupleBuilder;
import java.util.List;
import java.util.stream.Collectors;

class FieldInputTypeCache
extends FieldTypeCache<GraphQLInputType> {
    private final List<String> warnings;

    FieldInputTypeCache(NameMapping nameMapping, List<String> warnings) {
        super(nameMapping);
        this.warnings = warnings;
    }

    @Override
    protected GraphQLInputType compute(Column.ColumnType columnType) {
        if (columnType.isMap()) {
            GraphQLType keyType = (GraphQLType)this.get((Column.ColumnType)columnType.parameters().get(0));
            GraphQLType valueType = (GraphQLType)this.get((Column.ColumnType)columnType.parameters().get(1));
            return new MapBuilder(keyType, valueType, true).build();
        }
        if (columnType.isList() || columnType.isSet()) {
            return new GraphQLList((GraphQLType)this.get((Column.ColumnType)columnType.parameters().get(0)));
        }
        if (columnType.isUserDefined()) {
            UserDefinedType udt = (UserDefinedType)columnType;
            return this.computeUdt(udt);
        }
        if (columnType.isTuple()) {
            List<GraphQLType> subTypes = columnType.parameters().stream().map(this::get).collect(Collectors.toList());
            return new TupleBuilder(subTypes).buildInputType();
        }
        return this.getScalar(columnType.rawType());
    }

    private GraphQLInputType computeUdt(UserDefinedType udt) {
        String graphqlName = this.nameMapping.getGraphqlName(udt);
        if (graphqlName == null) {
            throw new SchemaWarningException(String.format("Could not find a GraphQL name mapping for UDT %s, this is probably because it clashes with another UDT", udt.name()));
        }
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject().name(graphqlName + "Input");
        for (Column column : udt.columns()) {
            String graphqlFieldName = this.nameMapping.getGraphqlName(udt, column);
            if (graphqlFieldName == null) continue;
            try {
                builder.field(GraphQLInputObjectField.newInputObjectField().name(graphqlFieldName).type((GraphQLInputType)this.get(column.type())).build());
            }
            catch (Exception e) {
                this.warnings.add(String.format("Could not create input type for field %s in UDT %s, skipping (%s)", column.name(), column.table(), e.getMessage()));
            }
        }
        return builder.build();
    }
}

