/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.NameConversions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameMapping {
    private static final Logger LOG = LoggerFactory.getLogger(NameMapping.class);
    private final BiMap<String, String> entityNames = HashBiMap.create();
    private final Map<String, BiMap<String, String>> columnNames;
    private final BiMap<String, String> udtNames = HashBiMap.create();
    private final Map<String, BiMap<String, String>> fieldNames;
    private final List<String> warnings;

    public NameMapping(Set<Table> tables, List<UserDefinedType> udts, List<String> warnings) {
        this.warnings = warnings;
        this.columnNames = new HashMap<String, BiMap<String, String>>();
        this.buildNames(tables);
        this.fieldNames = new HashMap<String, BiMap<String, String>>();
        this.buildNames(udts);
    }

    private void buildNames(Set<Table> tables) {
        for (Table table : tables) {
            String graphqlName = NameConversions.toGraphql(table.name(), NameConversions.IdentifierType.TABLE);
            String clashingCqlName = (String)this.entityNames.inverse().get((Object)graphqlName);
            if (clashingCqlName != null) {
                String message = String.format("Couldn't convert table %s because its GraphQL name %s would collide with table %s", table.name(), graphqlName, clashingCqlName);
                this.warnings.add(message);
                LOG.warn(message);
                continue;
            }
            if (!graphqlName.equals(table.name())) {
                this.warnings.add(String.format("Table %s mapped as %s", table.name(), graphqlName));
            }
            this.entityNames.put((Object)table.name(), (Object)graphqlName);
            this.columnNames.put(table.name(), this.buildColumnNames(table.columns()));
        }
    }

    private void buildNames(List<UserDefinedType> udts) {
        for (UserDefinedType udt : udts) {
            String graphqlName = NameConversions.toGraphql(udt.name(), NameConversions.IdentifierType.UDT);
            String clashingCqlName = (String)this.udtNames.inverse().get((Object)graphqlName);
            if (clashingCqlName != null) {
                String message = String.format("Could not convert UDT %s because its GraphQL name %s would collide with UDT %s", udt.name(), graphqlName, clashingCqlName);
                this.warnings.add(message);
                LOG.warn(message);
                continue;
            }
            if (!graphqlName.equals(udt.name() + "Udt")) {
                this.warnings.add(String.format("UDT %s mapped as %s", udt.name(), graphqlName));
            }
            this.udtNames.put((Object)udt.name(), (Object)graphqlName);
            this.fieldNames.put(udt.name(), this.buildColumnNames(udt.columns()));
        }
    }

    private BiMap<String, String> buildColumnNames(List<Column> columns) {
        HashBiMap map = HashBiMap.create();
        for (Column column : columns) {
            String graphqlName = NameConversions.toGraphql(column.name(), NameConversions.IdentifierType.COLUMN);
            String clashingCqlName = (String)map.inverse().get((Object)graphqlName);
            if (clashingCqlName != null) {
                String message = String.format("Could not convert column %s in table/UDT %s because its GraphQL name %s would collide with column %s", column.name(), column.table(), graphqlName, clashingCqlName);
                this.warnings.add(message);
                LOG.warn(message);
                continue;
            }
            if (!graphqlName.equals(column.name())) {
                this.warnings.add(String.format("Column %s in table/UDT %s mapped as %s", column.name(), column.table(), graphqlName));
            }
            map.put((Object)column.name(), (Object)graphqlName);
        }
        return map;
    }

    public String getGraphqlName(Table table) {
        return (String)this.entityNames.get((Object)table.name());
    }

    public String getGraphqlName(Table table, Column column) {
        return (String)this.columnNames.get(table.name()).get((Object)column.name());
    }

    public String getCqlName(Table table, String graphqlName) {
        return (String)this.columnNames.get(table.name()).inverse().get((Object)graphqlName);
    }

    public String getGraphqlName(UserDefinedType udt) {
        return (String)this.udtNames.get((Object)udt.name());
    }

    public String getGraphqlName(UserDefinedType udt, Column column) {
        return (String)this.fieldNames.get(udt.name()).get((Object)column.name());
    }

    public String getCqlName(UserDefinedType udt, String graphqlName) {
        return (String)this.fieldNames.get(udt.name()).inverse().get((Object)graphqlName);
    }
}

