/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.dml;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.condition.Condition;
import com.datastax.oss.driver.api.querybuilder.condition.ConditionBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.ArithmeticRelationBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.ColumnRelationBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLType;
import io.stargate.db.schema.Column;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.fetchers.dml.DataTypeMapping;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public abstract class FilterOperator
extends Enum<FilterOperator> {
    public static final /* enum */ FilterOperator EQUAL = new FilterOperator("eq"){

        @Override
        public Condition buildCondition(Column column, Object value, NameMapping nameMapping) {
            return FilterOperator.buildSimpleCondition(column, value, nameMapping, ArithmeticRelationBuilder::isEqualTo);
        }

        @Override
        public Relation buildRelation(Column column, Object value, NameMapping nameMapping) {
            return FilterOperator.buildSimpleRelation(column, value, nameMapping, ArithmeticRelationBuilder::isEqualTo);
        }
    };
    public static final /* enum */ FilterOperator NOT_EQUAL = new FilterOperator("notEq"){

        @Override
        public Condition buildCondition(Column column, Object value, NameMapping nameMapping) {
            return FilterOperator.buildSimpleCondition(column, value, nameMapping, ArithmeticRelationBuilder::isNotEqualTo);
        }

        @Override
        public Relation buildRelation(Column column, Object value, NameMapping nameMapping) {
            return FilterOperator.buildSimpleRelation(column, value, nameMapping, ArithmeticRelationBuilder::isNotEqualTo);
        }
    };
    public static final /* enum */ FilterOperator GREATER_THAN = new FilterOperator("gt"){

        @Override
        public Condition buildCondition(Column column, Object value, NameMapping nameMapping) {
            return FilterOperator.buildSimpleCondition(column, value, nameMapping, ArithmeticRelationBuilder::isGreaterThan);
        }

        @Override
        public Relation buildRelation(Column column, Object value, NameMapping nameMapping) {
            return FilterOperator.buildSimpleRelation(column, value, nameMapping, ArithmeticRelationBuilder::isGreaterThan);
        }
    };
    public static final /* enum */ FilterOperator GREATER_THAN_EQUAL = new FilterOperator("gte"){

        @Override
        public Condition buildCondition(Column column, Object value, NameMapping nameMapping) {
            return FilterOperator.buildSimpleCondition(column, value, nameMapping, ArithmeticRelationBuilder::isGreaterThanOrEqualTo);
        }

        @Override
        public Relation buildRelation(Column column, Object value, NameMapping nameMapping) {
            return FilterOperator.buildSimpleRelation(column, value, nameMapping, ArithmeticRelationBuilder::isGreaterThanOrEqualTo);
        }
    };
    public static final /* enum */ FilterOperator LESS_THAN = new FilterOperator("lt"){

        @Override
        public Condition buildCondition(Column column, Object value, NameMapping nameMapping) {
            return FilterOperator.buildSimpleCondition(column, value, nameMapping, ArithmeticRelationBuilder::isLessThan);
        }

        @Override
        public Relation buildRelation(Column column, Object value, NameMapping nameMapping) {
            return FilterOperator.buildSimpleRelation(column, value, nameMapping, ArithmeticRelationBuilder::isLessThan);
        }
    };
    public static final /* enum */ FilterOperator LESS_THAN_EQUAL = new FilterOperator("lte"){

        @Override
        public Condition buildCondition(Column column, Object value, NameMapping nameMapping) {
            return FilterOperator.buildSimpleCondition(column, value, nameMapping, ArithmeticRelationBuilder::isLessThanOrEqualTo);
        }

        @Override
        public Relation buildRelation(Column column, Object value, NameMapping nameMapping) {
            return FilterOperator.buildSimpleRelation(column, value, nameMapping, ArithmeticRelationBuilder::isLessThanOrEqualTo);
        }
    };
    public static final /* enum */ FilterOperator IN = new FilterOperator("in"){

        @Override
        public Condition buildCondition(Column column, Object value, NameMapping nameMapping) {
            return (Condition)Condition.column((String)column.name()).in((Iterable)FilterOperator.buildListLiterals(column, value, nameMapping));
        }

        @Override
        public Relation buildRelation(Column column, Object value, NameMapping nameMapping) {
            return (Relation)Relation.column((CqlIdentifier)CqlIdentifier.fromInternal((String)column.name())).in((Iterable)FilterOperator.buildListLiterals(column, value, nameMapping));
        }

        @Override
        public GraphQLInputObjectField buildField(GraphQLInputType gqlInputType) {
            return GraphQLInputObjectField.newInputObjectField().name(this.getFieldName()).type((GraphQLInputType)GraphQLList.list((GraphQLType)gqlInputType)).build();
        }
    };
    public static final /* enum */ FilterOperator CONTAINS = new FilterOperator("contains"){

        @Override
        public Condition buildCondition(Column column, Object value, NameMapping nameMapping) {
            throw new IllegalStateException("CONTAINS can't be used on IF conditions");
        }

        @Override
        public Relation buildRelation(Column column, Object value, NameMapping nameMapping) {
            return (Relation)Relation.column((CqlIdentifier)CqlIdentifier.fromInternal((String)column.name())).contains(FilterOperator.toCqlElementTerm(column, value, nameMapping));
        }
    };
    public static final /* enum */ FilterOperator CONTAINS_KEY = new FilterOperator("containsKey"){

        @Override
        public Condition buildCondition(Column column, Object value, NameMapping nameMapping) {
            throw new IllegalStateException("CONTAINS KEY can't be used on IF conditions");
        }

        @Override
        public Relation buildRelation(Column column, Object value, NameMapping nameMapping) {
            return (Relation)Relation.column((CqlIdentifier)CqlIdentifier.fromInternal((String)column.name())).containsKey(FilterOperator.toCqlKeyTerm(column, value, nameMapping));
        }
    };
    public static final /* enum */ FilterOperator CONTAINS_ENTRY = new FilterOperator("containsEntry"){

        @Override
        public Condition buildCondition(Column column, Object value, NameMapping nameMapping) {
            throw new IllegalStateException("CONTAINS ENTRY can't be used on IF conditions");
        }

        @Override
        public Relation buildRelation(Column column, Object value, NameMapping nameMapping) {
            Column.ColumnType mapType = column.type();
            assert (mapType != null && mapType.isMap());
            Map entry = (Map)value;
            Column.ColumnType keyType = (Column.ColumnType)mapType.parameters().get(0);
            Term keyTerm = DataTypeMapping.toCqlTerm(keyType, entry.get("key"), nameMapping);
            Column.ColumnType valueType = (Column.ColumnType)mapType.parameters().get(1);
            Term valueTerm = DataTypeMapping.toCqlTerm(valueType, entry.get("value"), nameMapping);
            return (Relation)Relation.mapValue((CqlIdentifier)CqlIdentifier.fromInternal((String)column.name()), (Term)keyTerm).isEqualTo(valueTerm);
        }
    };
    private static final Map<String, FilterOperator> mapByFieldName;
    private final String fieldName;
    private static final /* synthetic */ FilterOperator[] $VALUES;

    public static FilterOperator[] values() {
        return (FilterOperator[])$VALUES.clone();
    }

    public static FilterOperator valueOf(String name) {
        return Enum.valueOf(FilterOperator.class, name);
    }

    public static FilterOperator fromFieldName(String fieldName) {
        FilterOperator op = mapByFieldName.get(fieldName);
        if (op == null) {
            throw new IllegalArgumentException("Invalid filter field name: " + fieldName);
        }
        return op;
    }

    private static Map<String, FilterOperator> buildMapByFieldName() {
        return Arrays.stream(FilterOperator.values()).collect(Collectors.toMap(FilterOperator::getFieldName, o -> o));
    }

    public abstract Condition buildCondition(Column var1, Object var2, NameMapping var3);

    private static Condition buildSimpleCondition(Column column, Object value, NameMapping nameMapping, BiFunction<ConditionBuilder<Condition>, Term, Condition> operator) {
        return operator.apply((ConditionBuilder<Condition>)Condition.column((CqlIdentifier)CqlIdentifier.fromInternal((String)column.name())), DataTypeMapping.toCqlTerm(column.type(), value, nameMapping));
    }

    public abstract Relation buildRelation(Column var1, Object var2, NameMapping var3);

    private static Relation buildSimpleRelation(Column column, Object value, NameMapping nameMapping, BiFunction<ColumnRelationBuilder<Relation>, Term, Relation> operator) {
        return operator.apply((ColumnRelationBuilder<Relation>)Relation.column((CqlIdentifier)CqlIdentifier.fromInternal((String)column.name())), DataTypeMapping.toCqlTerm(column.type(), value, nameMapping));
    }

    public GraphQLInputObjectField buildField(GraphQLInputType gqlInputType) {
        return GraphQLInputObjectField.newInputObjectField().name(this.fieldName).type(gqlInputType).build();
    }

    private static List<Term> buildListLiterals(Column column, Object o, NameMapping nameMapping) {
        if (o instanceof Collection) {
            Collection values = (Collection)o;
            return values.stream().map(item -> DataTypeMapping.toCqlTerm(column.type(), item, nameMapping)).collect(Collectors.toList());
        }
        return Collections.singletonList(DataTypeMapping.toCqlTerm(column.type(), o, nameMapping));
    }

    private static Term toCqlKeyTerm(Column column, Object value, NameMapping nameMapping) {
        Column.ColumnType mapType = column.type();
        assert (mapType != null && mapType.isMap());
        Column.ColumnType keyType = (Column.ColumnType)mapType.parameters().get(0);
        return DataTypeMapping.toCqlTerm(keyType, value, nameMapping);
    }

    private static Term toCqlElementTerm(Column column, Object value, NameMapping nameMapping) {
        Column.ColumnType collectionType = column.type();
        assert (collectionType != null && collectionType.isCollection());
        Column.ColumnType elementType = (Column.ColumnType)collectionType.parameters().get(collectionType.isMap() ? 1 : 0);
        return DataTypeMapping.toCqlTerm(elementType, value, nameMapping);
    }

    private FilterOperator(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    static {
        $VALUES = new FilterOperator[]{EQUAL, NOT_EQUAL, GREATER_THAN, GREATER_THAN_EQUAL, LESS_THAN, LESS_THAN_EQUAL, IN, CONTAINS, CONTAINS_KEY, CONTAINS_ENTRY};
        mapByFieldName = FilterOperator.buildMapByFieldName();
    }
}

