/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.types.scalars;

import graphql.language.IntValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.math.BigInteger;

abstract class IntCoercing<DriverTypeT>
implements Coercing<DriverTypeT, Long> {
    static IntCoercing<Byte> TINYINT = new IntCoercing<Byte>(){

        @Override
        protected Byte fromBigInteger(BigInteger i) {
            return i.byteValueExact();
        }

        @Override
        protected Byte fromNumber(Number n) {
            this.checkRange(n, -128L, 127L);
            return n.byteValue();
        }
    };
    static IntCoercing<Short> SMALLINT = new IntCoercing<Short>(){

        @Override
        protected Short fromBigInteger(BigInteger i) {
            return i.shortValueExact();
        }

        @Override
        protected Short fromNumber(Number n) {
            this.checkRange(n, -32768L, 32767L);
            return n.shortValue();
        }
    };

    IntCoercing() {
    }

    protected abstract DriverTypeT fromBigInteger(BigInteger var1);

    protected abstract DriverTypeT fromNumber(Number var1);

    public Long serialize(Object dataFetcherResult) throws CoercingSerializeException {
        return ((Number)dataFetcherResult).longValue();
    }

    public DriverTypeT parseValue(Object input) throws CoercingParseValueException {
        if (input instanceof BigInteger) {
            return this.fromBigIntegerSafe((BigInteger)input);
        }
        if (input instanceof Integer || input instanceof Long) {
            return this.fromNumber((Number)input);
        }
        throw new CoercingParseLiteralException("Expected an integer literal");
    }

    public DriverTypeT parseLiteral(Object input) throws CoercingParseLiteralException {
        if (!(input instanceof IntValue)) {
            throw new CoercingParseLiteralException("Expected an integer literal");
        }
        IntValue value = (IntValue)input;
        return this.fromBigIntegerSafe(value.getValue());
    }

    private DriverTypeT fromBigIntegerSafe(BigInteger i) {
        try {
            return this.fromBigInteger(i);
        }
        catch (ArithmeticException e) {
            throw new CoercingParseLiteralException("Out of range");
        }
    }

    protected void checkRange(Number n, long min, long max) {
        long l = n.longValue();
        if (l < -128L || l > 127L) {
            throw new CoercingParseLiteralException("Out of range");
        }
    }
}

