/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.ddl.fetchers;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.UnauthorizedException;
import io.stargate.auth.entity.ResourceKind;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.schema.CassandraFetcher;
import io.stargate.graphql.schema.cqlfirst.ddl.fetchers.KeyspaceDto;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllKeyspacesFetcher
extends CassandraFetcher<List<KeyspaceDto>> {
    private static final Logger LOG = LoggerFactory.getLogger(AllKeyspacesFetcher.class);

    @Override
    protected List<KeyspaceDto> get(DataFetchingEnvironment environment, StargateGraphqlContext context) {
        return context.getDataStore().schema().keyspaces().stream().filter(keyspace -> {
            try {
                context.getAuthorizationService().authorizeSchemaRead(context.getSubject(), Collections.singletonList(keyspace.name()), null, SourceAPI.GRAPHQL, ResourceKind.KEYSPACE);
                return true;
            }
            catch (UnauthorizedException e) {
                LOG.debug("Not returning keyspace {} due to not being authorized", (Object)keyspace.name());
                return false;
            }
        }).map(keyspace -> new KeyspaceDto((Keyspace)keyspace, context.getAuthorizationService(), context.getSubject())).collect(Collectors.toList());
    }
}

