/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.ddl.fetchers;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.Scope;
import io.stargate.db.query.Query;
import io.stargate.db.query.builder.QueryBuilder;
import io.stargate.db.schema.CollectionIndexingType;
import io.stargate.db.schema.ImmutableCollectionIndexingType;
import io.stargate.graphql.schema.cqlfirst.ddl.fetchers.IndexFetcher;

public class CreateIndexFetcher
extends IndexFetcher {
    public CreateIndexFetcher() {
        super(Scope.CREATE);
    }

    @Override
    protected Query<?> buildQuery(DataFetchingEnvironment environment, QueryBuilder builder, String keyspaceName, String tableName) {
        String columnName = (String)environment.getArgument("columnName");
        String indexName = (String)environment.getArgument("indexName");
        boolean ifNotExists = (Boolean)environment.getArgumentOrDefault("ifNotExists", (Object)Boolean.FALSE);
        String customIndexClass = (String)environment.getArgumentOrDefault("indexType", null);
        String indexKind = (String)environment.getArgumentOrDefault("indexKind", null);
        boolean indexKeys = false;
        boolean indexEntries = false;
        boolean indexValues = false;
        boolean indexFull = false;
        if (indexKind != null) {
            switch (indexKind) {
                case "KEYS": {
                    indexKeys = true;
                    break;
                }
                case "VALUES": {
                    indexValues = true;
                    break;
                }
                case "ENTRIES": {
                    indexEntries = true;
                    break;
                }
                case "FULL": {
                    indexFull = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Invalid indexKind value: %s", indexKind));
                }
            }
        }
        ImmutableCollectionIndexingType indexingType = ImmutableCollectionIndexingType.builder().indexEntries(indexEntries).indexKeys(indexKeys).indexValues(indexValues).indexFull(indexFull).build();
        return builder.create().index(indexName).ifNotExists(ifNotExists).on(keyspaceName, tableName).column(columnName).indexingType((CollectionIndexingType)indexingType).custom(customIndexClass).build();
    }
}

