/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml.fetchers;

import graphql.GraphQLException;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.DmlFetcher;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public abstract class MutationFetcher
extends DmlFetcher<CompletableFuture<Map<String, Object>>> {
    protected MutationFetcher(Table table, NameMapping nameMapping) {
        super(table, nameMapping);
    }

    @Override
    protected CompletableFuture<Map<String, Object>> get(DataFetchingEnvironment environment, StargateGraphqlContext context) {
        BoundQuery query = null;
        Exception buildException = null;
        try {
            query = this.buildQuery(environment, context);
        }
        catch (Exception e) {
            buildException = e;
        }
        OperationDefinition operation = environment.getOperationDefinition();
        if (this.containsDirective(operation, "atomic") && operation.getSelectionSet().getSelections().size() > 1) {
            return this.executeAsPartOfBatch(environment, query, buildException, operation);
        }
        if (buildException != null) {
            CompletableFuture<Map<String, Object>> f = new CompletableFuture<Map<String, Object>>();
            f.completeExceptionally(buildException);
            return f;
        }
        if (this.containsDirective(operation, "async")) {
            return this.executeAsyncAccepted(query, environment.getArgument("value"), __ -> this.buildParameters(environment), context);
        }
        return context.getDataStore().execute(query, __ -> this.buildParameters(environment)).thenApply(rs -> this.toMutationResult((ResultSet)rs, environment.getArgument("value")));
    }

    private CompletableFuture<Map<String, Object>> executeAsPartOfBatch(DataFetchingEnvironment environment, BoundQuery query, Exception buildException, OperationDefinition operation) {
        int selections = environment.getOperationDefinition().getSelectionSet().getSelections().size();
        StargateGraphqlContext context = (StargateGraphqlContext)environment.getContext();
        StargateGraphqlContext.BatchContext batchContext = context.getBatchContext();
        if (environment.getArgument("options") != null && !batchContext.setParameters(this.buildParameters(environment))) {
            buildException = new GraphQLException("options can only de defined once in an @atomic mutation selection");
        }
        if (buildException != null) {
            batchContext.setExecutionResult(buildException);
        } else if (batchContext.add(query) == selections) {
            batchContext.setExecutionResult(context.getDataStore().batch(batchContext.getQueries(), __ -> batchContext.getParameters()));
        }
        if (this.containsDirective(operation, "async")) {
            return CompletableFuture.completedFuture(this.toAcceptedMutationResultWithOriginalValue(environment.getArgument("value")));
        }
        return batchContext.getExecutionFuture().thenApply(rows -> this.toBatchResult((List<Row>)rows, (Map)environment.getArgument("value")));
    }

    protected abstract BoundQuery buildQuery(DataFetchingEnvironment var1, StargateGraphqlContext var2) throws Exception;
}

