/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml.fetchers.aggregations;

import com.datastax.oss.driver.api.core.data.GettableByName;
import io.stargate.db.datastore.Row;
import java.util.Optional;
import java.util.function.BiFunction;

public enum SupportedGraphqlFunction {
    INT_FUNCTION("_int_function", GettableByName::getInt),
    DOUBLE_FUNCTION("_double_function", GettableByName::getDouble),
    BIGINT_FUNCTION("_bigint_function", GettableByName::getLong),
    DECIMAL_FUNCTION("_decimal_function", GettableByName::getBigDecimal),
    VARINT_FUNCTION("_varint_function", GettableByName::getBigInteger),
    FLOAT_FUNCTION("_float_function", GettableByName::getFloat),
    SMALLINT_FUNCTION("_smallint_function", GettableByName::getShort),
    TINYINT_FUNCTION("_tinyint_function", GettableByName::getByte);

    private final String name;
    private final BiFunction<Row, String, Object> rowValueExtractor;

    private SupportedGraphqlFunction(String name, BiFunction<Row, String, Object> rowValueExtractor) {
        this.name = name;
        this.rowValueExtractor = rowValueExtractor;
    }

    public String getName() {
        return this.name;
    }

    public BiFunction<Row, String, Object> getRowValueExtractor() {
        return this.rowValueExtractor;
    }

    public static Optional<SupportedGraphqlFunction> valueOfIgnoreCase(String functionName) {
        for (SupportedGraphqlFunction f : SupportedGraphqlFunction.values()) {
            if (!f.name.equalsIgnoreCase(functionName)) continue;
            return Optional.of(f);
        }
        return Optional.empty();
    }
}

